
// Diese Symbole werden durch ein Linker-Skript generiert
// Sie markieren Anfaung und Ende der .ctors and .dtors Sektionen
extern void (*__CTORS_START)();
extern void (*__CTORS_END)();
extern void (*__DTORS_START)();
extern void (*__DTORS_END)();

extern "C" void _exit( int );
int main();

const unsigned int STACK_SENTINEL = 0xFEE1C001;
const unsigned int STACK_ELEMENTS = 250;

extern "C" void _start() { 

	// Stackspeicher mit "Marker" initialisieren
	unsigned int* sp = 0;
	unsigned int tos = 0;
	for( sp = &tos; sp > &tos - STACK_ELEMENTS; --sp )
		*sp = STACK_SENTINEL;
	
	// Konstruktoren aller globalen Objektinstanzen aufrufen
	for( void (**ctor)() = &__CTORS_START; ctor != &__CTORS_END; ++ctor )
		(**ctor)();
	
	// Los gehts!
	main();

	// Destruktoren aller globalen Objektinstanzen aufrufen
	// (in umgekehrter Reihenfolge)
	for( void (**dtor)() = &__DTORS_END; dtor != &__DTORS_START; )
		(**--dtor)();
	
	// Maximalen Stackverbrauch ermitteln...
	for( sp = &tos; sp > &tos - STACK_ELEMENTS; --sp )
		if( *sp != STACK_SENTINEL )
			tos = (unsigned int) sp;

	// ...und als exitcode zurckgeben
	_exit( ((unsigned int)&tos) - tos ); 
}

