/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLflex;

import org.aspectix.AspectixException;
import org.aspectix.IDLflex.IDLObjectVector;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IDLflexException
extends AspectixException {
    IDLObject obj;
    IDLObjectVector generatepath;
    Node xmlnode;

    public boolean hasContext() {
        boolean bl = false;
        if (this.generatepath != null) {
            bl = true;
        }
        return bl;
    }

    private static final String constructMessage(String string, IDLObjectVector iDLObjectVector) {
        String string2 = string;
        if (iDLObjectVector == null) {
            return string2;
        }
        int n = iDLObjectVector.count_objects();
        if (n > 0) {
            string2 = string2 + "\nCurrent interface repository object: \n";
            string2 = string2 + IDLflexException.printObjectPath(iDLObjectVector);
        }
        if ((n = iDLObjectVector.count_nodes()) > 0) {
            string2 = string2 + "\nPath to the current node in the XML document:\n";
            string2 = string2 + IDLflexException.printNodePath(iDLObjectVector) + '\n';
        }
        return string2;
    }

    private static final String printObjectPath(IDLObjectVector iDLObjectVector) {
        String string = "";
        int n = 0;
        try {
            IDLObject iDLObject;
            while ((iDLObject = iDLObjectVector.getUpperObject(n)) != null) {
                ++n;
                String string2 = iDLObject.getName("name") + " [ " + iDLObject.getName("id") + " ] { " + iDLObject + " } \n";
                string = string + string2;
            }
            return string;
        }
        catch (IDLflexException iDLflexException) {
            return "";
        }
    }

    private static final String printNodeName(Node node) {
        String string = node.getNodeName();
        try {
            Element element = (Element)node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            if (n > 0) {
                string = string + '(';
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = namedNodeMap.item(n2);
                    string = string + (n2 > 0 ? " " : "") + node2.getNodeName() + '=' + node2.getNodeValue();
                    ++n2;
                }
                string = string + ')';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static final String printNodePath(IDLObjectVector iDLObjectVector) {
        String string = "";
        try {
            int n = iDLObjectVector.count_nodes();
            int n2 = 0;
            while (n2 < n) {
                Node node = iDLObjectVector.nodeAt(n2);
                string = string + IDLflexException.printNodeName(node) + '\n';
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Node node = iDLObjectVector.nodeAt(iDLObjectVector.count_nodes() - 1);
        string = string + "\n-----XML path---\n" + IDLflexException.printNodeName(node) + '\n';
        try {
            Node node2 = node.getParentNode();
            while (node2 != null) {
                node = node2;
                string = string + IDLflexException.printNodeName(node) + '\n';
                node2 = node.getParentNode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public IDLflexException(String string) {
        super(string);
        this.generatepath = null;
    }

    public IDLflexException(IDLObjectVector iDLObjectVector, String string) {
        super(IDLflexException.constructMessage(string, iDLObjectVector));
        this.generatepath = iDLObjectVector;
    }
}

