/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLflex;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aspectix.IDLflex.IDLDefCompiler;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.IDLflexMain;
import org.aspectix.IDLflex.IRObj.IDLIterationPseudo;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.aspectix.IDLflex.IRObj.ModuleObj;
import org.aspectix.IDLflex.IRObj.PrimitiveObj;
import org.aspectix.IDLflex.IRObj.StringObj;
import org.aspectix.IDLflex.Plugin;
import org.aspectix.IDLflex.SaveBox;
import org.aspectix.IDLflex.UtilityResolvedPath;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCode;

public abstract class Utility {
    IDLDefCompiler compiler = null;
    IDLObject refObj = null;
    private static Hashtable basic_mapping;
    private String[] outerModules;
    private String defaultModule;
    public SaveBox savebox;
    private static Hashtable iro_resolver;

    public void init(IDLDefCompiler iDLDefCompiler) {
        this.compiler = iDLDefCompiler;
        basic_mapping = this.compiler.getMapTable("BasicMapping");
        this.savebox = new SaveBox();
        String string = IDLflexMain.argsAttributes.getDefined("USEMODULE");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n = stringTokenizer.countTokens();
            this.outerModules = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.outerModules[n2] = stringTokenizer.nextToken();
                ++n2;
            }
        } else {
            this.outerModules = null;
        }
        this.defaultModule = IDLflexMain.argsAttributes.getDefined("DEFMODULE");
        this.compiler.registerPlugin("Counter", "org.aspectix.IDLflex.Counter");
    }

    public void setReferenceObject(IDLObject iDLObject) {
        this.refObj = iDLObject;
    }

    public IDLObject getReferenceObject() {
        return this.refObj;
    }

    private static int object2tckvalue(IDLObject iDLObject) {
        if (iDLObject != null) {
            if (iDLObject.is_a("PrimitiveObj")) {
                try {
                    return (Integer)iDLObject.getValue("tckind");
                }
                catch (IDLflexException iDLflexException) {
                    System.err.println("fatal error: PrimitiveObject does nothave tckind value!");
                    throw new RuntimeException();
                }
            }
            if (iDLObject.is_a("StringObj")) {
                try {
                    if (iDLObject.getAttribute("wide")) {
                        return 27;
                    }
                    return 18;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (iDLObject.is_a("FixedObj")) {
                return 28;
            }
        }
        return -1;
    }

    public static final String get_basic_mapping(IDLObject iDLObject) throws IDLflexException {
        String string = null;
        if (iDLObject instanceof PrimitiveObj) {
            string = iDLObject.getName("name");
        } else if (iDLObject instanceof StringObj) {
            string = iDLObject.getAttribute("wide") ? "tk_wstring" : "tk_string";
        } else {
            throw new IDLflexException("not a basic type");
        }
        String string2 = (String)basic_mapping.get(string);
        return string2;
    }

    public static final String tckvalue2string(int n) throws IDLflexException {
        switch (n) {
            case 0: {
                return "tk_null";
            }
            case 1: {
                return "tk_void";
            }
            case 8: {
                return "tk_boolean";
            }
            case 9: {
                return "tk_char";
            }
            case 26: {
                return "tk_wchar";
            }
            case 10: {
                return "tk_octet";
            }
            case 18: {
                return "tk_string";
            }
            case 27: {
                return "tk_wstring";
            }
            case 2: {
                return "tk_short";
            }
            case 4: {
                return "tk_ushort";
            }
            case 3: {
                return "tk_long";
            }
            case 5: {
                return "tk_ulong";
            }
            case 23: {
                return "tk_longlong";
            }
            case 24: {
                return "tk_ulonglong";
            }
            case 6: {
                return "tk_float";
            }
            case 7: {
                return "tk_double";
            }
            case 28: {
                return "tk_fixed";
            }
            case 25: {
                return "tk_longdouble";
            }
            case 12: {
                return "tk_TypeCode";
            }
            case 17: {
                return "tk_enum";
            }
            case 11: {
                return "tk_any";
            }
            case 14: {
                return "tk_objref";
            }
            case 15: {
                return "tk_struct";
            }
            case 16: {
                return "tk_union";
            }
            case 19: {
                return "tk_sequence";
            }
            case 20: {
                return "tk_array";
            }
            case 21: {
                return "tk_alias";
            }
            case 22: {
                return "tk_except";
            }
            case 32: {
                return "tk_abstract_interface";
            }
            case 29: {
                return "tk_value";
            }
            case 30: {
                return "tk_value_box";
            }
            case 31: {
                return "tk_native";
            }
        }
        throw new IDLflexException("Cannot find basic mapping for type " + n);
    }

    public static final String get_primitive_name(IDLObject iDLObject) throws IDLflexException {
        if (iDLObject instanceof PrimitiveObj) {
            String string = iDLObject.getName("name");
            if (string.equals("tk_objref")) {
                return "Object";
            }
            if (string.equals("tk_value")) {
                return "Value";
            }
            return string.substring(3);
        }
        if (iDLObject instanceof StringObj) {
            return "String";
        }
        throw new IDLflexException("Cannot find basic mapping for " + iDLObject);
    }

    public static final String extractUnionDiscrType(IDLObject iDLObject) throws IDLflexException {
        TypeCode typeCode = iDLObject.is_a("UnionMemberObj") ? (TypeCode)iDLObject.getContent("SUPER").getValue("discrtype") : (TypeCode)iDLObject.getValue("discrtype");
        return Utility.tckvalue2string(typeCode.kind().value());
    }

    public static String escapeString(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n\t", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string3.equals("\r") ? string2 + "\\r" : (string3.equals("\n") ? string2 + "\\n" : (string3.equals("\t") ? string2 + "\\t" : string2 + string3));
        }
        return string2;
    }

    public static final String extractAnyValue(Any any) {
        TypeCode typeCode = any.type();
        switch (typeCode.kind().value()) {
            case 8: {
                return any.extract_boolean() ? "1" : "0";
            }
            case 9: {
                return "'" + any.extract_char() + "'";
            }
            case 26: {
                return "'" + any.extract_wchar() + "'";
            }
            case 10: {
                return String.valueOf(any.extract_octet());
            }
            case 18: {
                String string = any.extract_string();
                if (string.startsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                return string;
            }
            case 27: {
                String string = any.extract_wstring();
                if (string.startsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                return string;
            }
            case 2: {
                return String.valueOf(any.extract_short());
            }
            case 4: {
                return String.valueOf(any.extract_ushort());
            }
            case 3: {
                return String.valueOf(any.extract_long());
            }
            case 5: {
                return String.valueOf(any.extract_ulong());
            }
            case 23: {
                return String.valueOf(any.extract_longlong());
            }
            case 24: {
                return String.valueOf(any.extract_ulonglong());
            }
            case 6: {
                return String.valueOf(any.extract_float());
            }
            case 7: {
                return String.valueOf(any.extract_double());
            }
            case 28: {
                return String.valueOf(any.extract_fixed());
            }
            case 25: {
                return "<longdouble: unsupported>";
            }
        }
        System.err.println("extractAnyConst: Unsupportet Type " + typeCode.kind().value() + " in Any " + any);
        return "";
    }

    public final UtilityResolvedPath resolve(IDLObject iDLObject) {
        if (iro_resolver.contains(iDLObject)) {
            return (UtilityResolvedPath)iro_resolver.get(iDLObject);
        }
        UtilityResolvedPath utilityResolvedPath = this.real_resolve(iDLObject);
        iro_resolver.put(iDLObject, utilityResolvedPath);
        return utilityResolvedPath;
    }

    private final UtilityResolvedPath real_resolve(IDLObject iDLObject) {
        UtilityResolvedPath utilityResolvedPath = null;
        try {
            IDLObject iDLObject2 = iDLObject.getContent("CONTAINER");
            if (iDLObject2 != null) {
                utilityResolvedPath = this.real_resolve(iDLObject2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (utilityResolvedPath != null) {
            utilityResolvedPath.add(iDLObject);
        } else {
            utilityResolvedPath = new UtilityResolvedPath();
            if (this.outerModules != null) {
                int n = 0;
                while (n < this.outerModules.length) {
                    utilityResolvedPath.add(this.outerModules[n], new ModuleObj());
                    ++n;
                }
            }
        }
        return utilityResolvedPath;
    }

    public String getName(String string, IDLObject iDLObject) throws IDLflexException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (string3.equalsIgnoreCase("DEF")) {
            String string4 = IDLflexMain.argsAttributes.getDefined(string2);
            if (string4 != null) {
                return string4;
            }
            throw new IDLflexException("No such definition: " + string2);
        }
        if (string3.equalsIgnoreCase("IDL")) {
            if (string2.equals("")) {
                return iDLObject.getName("name");
            }
            return iDLObject.getName(string2);
        }
        if (string3.equalsIgnoreCase("SBOX")) {
            String string5 = this.savebox.get(string2);
            if (string5 == null) {
                throw new IDLflexException("SBOX(" + string2 + ") does not exist!");
            }
            return string5;
        }
        if (string3.equalsIgnoreCase("PLUGIN")) {
            Plugin plugin = this.compiler.getPlugin(string2);
            return plugin.getName("");
        }
        if (string3.equalsIgnoreCase("NAME")) {
            return iDLObject.getName("name");
        }
        if (string3.equalsIgnoreCase("LIST")) {
            String string6;
            int n2 = string2.indexOf(":");
            if (n2 == -1) {
                string6 = "MEMBER";
            } else {
                string6 = string2.substring(n2 + 1);
                string2 = string2.substring(0, n2);
            }
            if (string2.equalsIgnoreCase("Count")) {
                IDLObject[] iDLObjectArray = iDLObject.getContentList(string6);
                return "" + iDLObjectArray.length;
            }
            throw new IDLflexException("list:" + string2 + ": invalid expression");
        }
        if (string3.equalsIgnoreCase("LOOP")) {
            IDLIterationPseudo iDLIterationPseudo = this.compiler.getIterationPseudo();
            if (iDLIterationPseudo == null) {
                throw new IDLflexException("<GET LOOP:.../> used outside iteration context!");
            }
            if (string2.equalsIgnoreCase("Index")) {
                return String.valueOf(iDLIterationPseudo.index);
            }
            if (string2.equalsIgnoreCase("Count")) {
                return String.valueOf(iDLIterationPseudo.count);
            }
            if (string2.equalsIgnoreCase("RIndex")) {
                return String.valueOf(iDLIterationPseudo.count - iDLIterationPseudo.index - 1);
            }
            throw new IDLflexException("LOOP:" + string2 + ": invalid expression");
        }
        throw new IDLflexException("Utility: getName: invalid spec: " + string + " on Object " + iDLObject);
    }

    public boolean getAttribute(String string, IDLObject iDLObject) throws IDLflexException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "";
        }
        if (string3.equalsIgnoreCase("DEF")) {
            return IDLflexMain.argsAttributes.isDefined(string2);
        }
        if (string3.equalsIgnoreCase("LOOP")) {
            IDLIterationPseudo iDLIterationPseudo = this.compiler.getIterationPseudo();
            if (iDLIterationPseudo == null) {
                throw new IDLflexException("LOOP:... used outside ofiteration context!");
            }
            if (string2.equalsIgnoreCase("First")) {
                return iDLIterationPseudo.index == 0;
            }
            if (string2.equalsIgnoreCase("Notfirst")) {
                return iDLIterationPseudo.index > 0;
            }
            if (string2.equalsIgnoreCase("Last")) {
                return iDLIterationPseudo.index == iDLIterationPseudo.count - 1;
            }
            if (string2.equalsIgnoreCase("Notlast")) {
                return iDLIterationPseudo.index < iDLIterationPseudo.count - 1;
            }
            throw new IDLflexException("LOOP:" + string2 + ": invalid attribute");
        }
        if (string3.equalsIgnoreCase("HAVE")) {
            if (string2.equalsIgnoreCase("RETURN")) {
                IDLObject iDLObject2 = iDLObject.getContent("RETURN");
                if (iDLObject2 == null) {
                    throw new IDLflexException("get Attribute: HAVE: no such Content RETURN in Object " + iDLObject);
                }
                return !iDLObject2.is_a("PrimitiveObj") || !iDLObject2.getName("name").equals("tk_void");
            }
            IDLObject[] iDLObjectArray = iDLObject.getContentList(string2);
            if (iDLObjectArray == null) {
                throw new IDLflexException("getAttribute: HAVE: no such ContentList '" + string2 + "' in Object " + iDLObject);
            }
            return iDLObjectArray.length > 0;
        }
        if (string3.equalsIgnoreCase("IDL")) {
            return iDLObject.getAttribute(string2);
        }
        if (string3.equalsIgnoreCase("OBJ")) {
            System.err.println("Use of deprecated 'OBJ:' -- use 'IDL:' instead!");
            return iDLObject.getAttribute(string2);
        }
        if (string3.equalsIgnoreCase("CORBA")) {
            UtilityResolvedPath utilityResolvedPath = this.resolve(iDLObject);
            try {
                if (utilityResolvedPath.name(0).equals("org") && utilityResolvedPath.name(1).equals("omg")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        throw new IDLflexException("Unsupported Attribute " + string + "\n");
    }

    static {
        iro_resolver = new Hashtable();
    }
}

