/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.aspectix.IDLparser.pub.IDLConst;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLTypeUtil;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.util.IDLIterator;

public class ConstExpNode
extends IDLEntityNode
implements IDLConst {
    private static final int MIN_ACCURACY = 20;
    private static final int MAX_ACCURACY = 9871;

    public int getType() {
        return 26;
    }

    public BigDecimal numberValue() throws IDLException {
        IDLIterator iDLIterator = this.iterator();
        IDLEntityNode iDLEntityNode = null;
        Object var4_3 = null;
        String string = this.getText();
        IDLEntityNode iDLEntityNode2 = (IDLEntityNode)iDLIterator.next();
        if (iDLIterator.hasNext()) {
            iDLEntityNode = (IDLEntityNode)iDLIterator.next();
        }
        if (iDLEntityNode == null) {
            BigDecimal bigDecimal = ((IDLConst)((Object)iDLEntityNode2)).numberValue();
            if (string.equals("none") || string.equals("+")) {
                return bigDecimal;
            }
            if (string.equals("-")) {
                return bigDecimal.negate();
            }
            if (string.equals("~")) {
                if (bigDecimal.scale() != 0) {
                    throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): operation " + this.getText() + " may not be performed on " + bigDecimal.toString());
                }
                return new BigDecimal(bigDecimal.unscaledValue().not(), 0);
            }
            throw new IDLException("(" + LocationInfo.getLocationInfo(this.getLine()) + "): unknown operation to perform " + this.getText() + " on constant expression " + bigDecimal.toString());
        }
        BigDecimal bigDecimal = ((IDLConst)((Object)iDLEntityNode2)).numberValue();
        BigDecimal bigDecimal2 = ((IDLConst)((Object)iDLEntityNode)).numberValue();
        if (string.equals("*")) {
            return bigDecimal.multiply(bigDecimal2);
        }
        if (string.equals("/")) {
            int n = bigDecimal.scale() - bigDecimal2.scale();
            if (n < 0) {
                n = 0;
            }
            if ((n += 20) > 9871) {
                n = 9871;
            }
            return bigDecimal.divide(bigDecimal2, n, 4);
        }
        if (string.equals("+")) {
            return bigDecimal.add(bigDecimal2);
        }
        if (string.equals("-")) {
            return bigDecimal.subtract(bigDecimal2);
        }
        if (bigDecimal.scale() != 0) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): operation " + this.getText() + " may not be performed on floating_pt expression " + bigDecimal.toString());
        }
        if (bigDecimal2.scale() != 0) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): operation " + this.getText() + " may not be performed on floating_pt expression " + bigDecimal2.toString());
        }
        BigInteger bigInteger = bigDecimal.unscaledValue();
        BigInteger bigInteger2 = bigDecimal2.unscaledValue();
        if (string.equals("%")) {
            return new BigDecimal(bigInteger.mod(bigInteger2), 0);
        }
        if (string.equals("<<")) {
            return new BigDecimal(bigInteger.shiftLeft(bigInteger2.intValue()), 0);
        }
        if (string.equals(">>")) {
            return new BigDecimal(bigInteger.shiftRight(bigInteger2.intValue()), 0);
        }
        if (string.equals("&")) {
            return new BigDecimal(bigInteger.and(bigInteger2), 0);
        }
        if (string.equals("|")) {
            return new BigDecimal(bigInteger.or(bigInteger2), 0);
        }
        if (string.equals("^")) {
            return new BigDecimal(bigInteger.xor(bigInteger2), 0);
        }
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unknown operation to perform " + this.getText() + " on constant expressions " + bigDecimal.toString() + " and " + bigDecimal2.toString());
    }

    public String stringValue(int n) throws IDLException {
        IDLIterator iDLIterator = this.iterator();
        IDLConst iDLConst = (IDLConst)iDLIterator.next();
        throw new IDLException("error(line " + LocationInfo.getLocationInfo(iDLConst.getLine()) + "): Can't assign this constant expression to type " + IDLTypeUtil.toString(n));
    }
}

