/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLparser.tree;

import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.aspectix.IDLparser.pub.IDLScopeStack;
import org.aspectix.IDLparser.pub.IDLScopedName;
import org.aspectix.IDLparser.pub.IDLTracer;
import org.aspectix.IDLparser.pub.IDLType;
import org.aspectix.IDLparser.pub.IDLTypeUtil;
import org.aspectix.IDLparser.pub.LocationInfo;
import org.aspectix.IDLparser.tree.ConstDefNode;
import org.aspectix.IDLparser.tree.IDLEntityNode;
import org.aspectix.IDLparser.tree.LookupUtil;

public class ScopedNameNode
extends IDLEntityNode
implements IDLScopedName {
    private boolean scopeResolution = false;
    boolean resolved = false;
    IDLEntityNode referencedNode = null;

    public int getType() {
        return 27;
    }

    public String getLocalName() {
        int n = this.getText().lastIndexOf("::");
        if (n == -1) {
            return this.getText();
        }
        return this.getText().substring(n + 2);
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack(this.getText(), "::");
    }

    public void resolveReferences() throws IDLException {
        if (IDLTracer.instance().tracing()) {
            IDLTracer.instance().println("RESOLVING scoped name " + this.getScopedName() + " in line " + this.getLine());
        }
        if (!this.resolved) {
            this.resolved = true;
            if (!this.used()) {
                return;
            }
            if (this.shadowCopy()) {
                throw new IDLException("error (line " + LocationInfo.getLocationInfo(this.getLine()) + "): scoped name " + this.getScopedName() + " resolved in shadow node");
            }
            this.referencedNode = LookupUtil.instance().resolveReference(this);
        }
    }

    public IDLEntityNode getReference() throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.referencedNode == null) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): name not found - " + this.getText());
        }
        return this.referencedNode;
    }

    public void setScopeResolution() {
        this.scopeResolution = true;
    }

    public boolean scopeResolution() {
        return this.scopeResolution;
    }

    public IDLType getReferencedType() throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.referencedNode == null) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unknown type " + this.getText());
        }
        if (!(this.referencedNode instanceof IDLType)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): not a type: " + this.getText());
        }
        return (IDLType)((Object)this.referencedNode);
    }

    boolean usesUnqualified(String string) {
        if (!this.used() || this.shadowCopy()) {
            return false;
        }
        if (this.getText().startsWith("::")) {
            return false;
        }
        IDLScopeStack iDLScopeStack = this.getScopedName();
        while (!iDLScopeStack.isEmpty()) {
            if (!((String)iDLScopeStack.pop()).equals(string)) continue;
            return true;
        }
        return false;
    }

    public IDLType getEffectiveType() throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.referencedNode == null) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unknown type " + this.getText());
        }
        if (!(this.referencedNode instanceof IDLType)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): not a type: " + this.getText());
        }
        return ((IDLType)((Object)this.referencedNode)).getEffectiveType();
    }

    public Object matchValue(IDLNode iDLNode) throws IDLException {
        return this.getEffectiveType().matchValue(iDLNode);
    }

    public int getTypeId() {
        return 17;
    }

    public String stringValue(int n) throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.referencedNode == null) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unknown constant " + this.getText());
        }
        if (!(this.referencedNode instanceof ConstDefNode)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): not a constant: " + this.getText());
        }
        IDLType iDLType = ((ConstDefNode)this.referencedNode).getIDLType().getEffectiveType();
        if (iDLType.getTypeId() != n) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): " + this.getText() + " is not of type " + IDLTypeUtil.toString(n));
        }
        return ((ConstDefNode)this.referencedNode).getValue().toString();
    }

    public BigDecimal numberValue() throws IDLException {
        if (!this.resolved) {
            this.throwNotResolvedException();
        }
        if (this.referencedNode == null) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): unknown constant " + this.getText());
        }
        if (!(this.referencedNode instanceof ConstDefNode)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): not a constant: " + this.getText());
        }
        IDLType iDLType = ((ConstDefNode)this.referencedNode).getIDLType().getEffectiveType();
        int n = iDLType.getTypeId();
        if (n != 4 && n != 5 && n != 16) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): expression " + this.getText() + " cannot be assigned to number type ");
        }
        Object object = ((ConstDefNode)this.referencedNode).getValue();
        if (!(object instanceof BigDecimal)) {
            throw new IDLException("error(line " + LocationInfo.getLocationInfo(this.getLine()) + "): constant expression " + object.toString() + " cannot be assigned to number type ");
        }
        return (BigDecimal)object;
    }
}

