#ifndef __buffer_hpp__
#define __buffer_hpp__

#include <iostream>
#include <cstdlib>

using std::memcpy;

class BufferException {
	
};

class Buffer {
	public:
		Buffer(char* data, int l) :
			buffer(data), len(l) {
		}
		Buffer(int size) :
			buffer(new char[size]), len(size) {
		}
		Buffer(const Buffer& b, int size) :
			buffer(new char[size]), len(size) {
			int cpySize = size;
			if (size > b.len)
				cpySize = b.len;
			memcpy(buffer, b.buffer, cpySize);
		}
		~Buffer() {
			delete[] buffer;
		}
		char& operator[](int index) {
			if (index < len) {
				return buffer[index];
			} else {
				throw BufferException();
			}
		}	
		int length() {
			return len;
		}
		private:
			char *buffer;
			int len;
			
		friend class MyResizeHandler;
};
#endif
