/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                G U A R D                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Mit Hilfe dieser Klasse koennen Aktivitaeten, die einen kritischen        */
/* Abschnitt betreffen, der mit einem Guard-Objekt geschuetzt ist, mit       */
/* Unterbrechungsbehandlungsroutinen synchronisiert werden, die ebenfalls    */
/* auf den kritischen Abschnitt zugreifen.                                   */
/*****************************************************************************/

#ifndef __Guard_include__
#define __Guard_include__

#include "interrupt/dsr_executor.h"
#include "interrupt/gate.h"
#include "interrupt/locker.h"
#include "object/queue.h"

/**
 * \class Guard
 * \brief Securing critical sections of the os kernel.
 *
 * Implementation of secured sections. When entering a secured section
 * Guard::enter() is called and the execution of dsrs is prohibited.
 * When leaving a secured section, Guard::leave() is called, within this
 * method pending dsrs are executed and the scheduler is activated
 * if necessary.
 */
class Guard : public Locker, public DSR_Executor {
   
public:

  /**
   * \brief Leave a secured section.
   *
   * When a secured section is left, pending dsrs are executed and the
   * scheduler is activated if necessary.
   */
  void leave();
};

extern "C" void guard_enter();
extern "C" void guard_leave();

extern Guard guard;

#endif
