#include "interrupt/vectors.inc"
	
	.extern		_guardian
	.extern		_guard_enter
	.extern		_guard_leave
	.extern		_interrupt_end
	.extern		_decode_int
	.extern		_start
	.extern		__isr_stack_end
	.extern		__dsr_stack_end
	.extern		__stack_end
	
	.global		_reset
	.global		reset
	.section	.cartridge_header
	
	# this is the reset vector, we directly jump here coming from the
	# cartridge header, for now we keep it very simple, we just jump
	# directly to the start routine still running on the small interrupt
	# stack of the gba bios - later we should change this and use the
	# application stack to prevent stack overflows
reset:
_reset:
	b	ram_start

	# GBA cartridges have a special header, every cartridge
	# has to stick to this header, especially the nintendo logo
	# otherwise the GBA won't boot, we do not care for this stuff
	# here we just fill the space, the rest is done by the gbafix tool
	# all in all we have to fill 224 Bytes here, i.e. 56 longs
	
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000,0x00000000,0x00000000,0x00000000
	.long 0x00000000
	

	# here we initialize the stack for startup and set the interrupt
	# vector

	.global		ram_start
	.global		wrapper_body
	.section	.text
	
ram_start:
_ram_start:

    
	init_stack

	# set up the interrupt handler
	
	ldr	r0,=wrapper_body
	#(ARM7)
	#ldr	r1,=0x03007FFC 
	
	#ARM9 interrupt handlers address is stored at 0x00803FFC (!)
	ldr r1,=0x00803FFC
	str	r0,[r1]

	b	start
	

	# common body of all interrupt handlers

	# in the GBA we do not habe direct access to the interrupt vector
	# as the real interrupt vector is located in the bios rom, this handler
	# executes the following instructions
	
	# b      128h                IRQ vector: jump to actual BIOS handler
	# stmfd  sp!,r0-r3,r12,r14   save registers to SP_irq
	# mov    r0,4000000h         ptr+4 to 03FFFFFC (mirror of 03007FFC)
	# add    r14,r15,0h          retadr for USER handler $+8=138h
	# ldr    r15,[r0,-4h]        jump to [03FFFFFC] USER handler
	# ldmfd  sp!,r0-r3,r12,r14   restore registers from SP_irq
	# subs   r15,r14,4h          return from IRQ (PC=LR-4, CPSR=SPSR)
		
wrapper_body:

	save_context
			
	# enter a secured section

	bl	guard_enter

	# decode the interrupt vector from the IF register

	bl	decode_int
	
	# interrupt vector is located in r0
	# call the guardian, execute the isr and
	# post a dsr if necessary
	# interrupts are enabled here again
	
	bl	guardian

	switch_to_thread_stack
	
	bl	guard_leave

	return_from_wrapper

