#ifndef __interrupt_vectors_h__
#define __interrupt_vectors_h__

/**
 * \file vectors.h
 * \brief A list of all available interrupt sources and the according vector number
 **/

/**
 * \brief The count of the GBA's interrupt vectors
 **/
#define VECTORS_COUNT 14

/**
 * \brief The interrupt vectors of the gba
 **/
#define VECTORS								\
    lcdvb  = 0,   /* LCD V-Blank */					\
    lcdhb  = 1,   /* LCD H-Blank */					\
    lcdvcm = 2,   /* LCD V-Counter Match */				\
    tm0    = 3,   /* Timer 0 Overflow */				\
    tm1    = 4,   /* Timer 1 Overflow */				\
    tm2    = 5,   /* Timer 2 Overflow */				\
    tm3    = 6,   /* Timer 3 Overflow */				\
    sc     = 7,   /* Serial Communication */				\
    dma0   = 8,   /* DMA 0 */						\
    dma1   = 9,   /* DMA 1 */						\
    dma2   = 10,  /* DMA 2 */						\
    dma3   = 11,  /* DMA 3 */						\
    kp     = 12,  /* Keypad */					        \
    gp     = 13   /* Game Pak (external IRQ Source */

#endif /* __interrupt_vectors_h__ */
