/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              S T A C K                                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung eines Stacks als einfach verkettete Liste von Chain       */
/* Objekten. Initial ist der Stack leer.                                     */
/*****************************************************************************/

#ifndef __stack_h__
#define __stack_h__

#include "object/chain.h"

/**
 * \class Stack
 * \brief A stack implementation, based on a single linked list
 **/
class Stack {
protected:

  /**
   * \brief Top of stack
   **/
  Chain* top;

public:

  /**
   * \brief Constructor
   **/
  Stack() : top(0) {}

  /**
   * \brief Is the stack empty?
   * \retval true The stack is empty
   * \retval false The stack is not empty
   **/
  bool empty() { return top == 0; }

  /**
   * \brief Get the topmost element of the stack but don't remove it
   * \return The topmost element of the stack
   **/
  Chain* peek() { return top; }

  /**
   * \brief Get the topmost element of the stack and remove it
   * \return the topmost element of the stack
   **/
  Chain* pop() {
    Chain* result = top;

    if(result != 0) {
      top = result->next;
      result->next = 0;
    }

    return result;
  }

  /**
   * \brief Add an element to the stack
   * \param item The element to be added to the stack
   * \attention Each element may only be added once, otherwise the internal
   *            structure of the stack will be destroyed.
   **/
  void push(Chain* item) {
    item->next = top;
    top = item;
  }

  /**
   * \brief Remove an element of the stack
   * \param item The element to be removed from the stack
   **/
  void remove(Chain* item);
};

#endif /* __stack_h__ */
