/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*           S C H E D U L E R _ I M P L E M E N T A T I O N                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Schnittstelle der eigentlichen Schedulerimplementierung, die gegen        */
/* Unterbrechungen geschützt ist.                                            */
/*****************************************************************************/

#ifndef __guarded_scheduler_implementation_h__
#define __guarded_scheduler_implementation_h__

#include "interrupt/secure.h"
#include "thread/scheduler_implementation.h"

class Guarded_Scheduler_Implementation : protected Scheduler_Implementation {

public:

  void add(Thread* thread) {
    Secure section;
    Scheduler_Implementation::add(thread);
  }

  void remove(Thread* thread) {
    Secure section;
    Scheduler_Implementation::remove(thread);
  }

  void yield() {
    Secure section;
    Scheduler_Implementation::yield();
  }

  void kill(Thread* thread) {
    Secure section;
    Scheduler_Implementation::kill(thread);
  }

  void exit() {
    Secure section;
    Scheduler_Implementation::exit();
  }

  void block(Thread* thread,Queue* queue) {
    Secure section;
    Scheduler_Implementation::block(thread,queue);
  }

  void wakeup(Thread* thread) {
    Secure section;
    Scheduler_Implementation::wakeup(thread);
  }

  us_type set_timeslice(us_type timeslice) {
    return Scheduler_Implementation::set_timeslice(timeslice);
  }

  us_type get_timeslice() {
    return Scheduler_Implementation::get_timeslice();
  }
};

#endif /* __guarded_scheduler_implementation_h__ */
