/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          R U N N A B L E                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Klasse Runnable bietet dem Benutzer die Möglichkeit eigene            */
/* Funktionalität einzubringen, indem die Methode action() implementiert wird*/
/* Die Methode action() wird dabei immer vom Anfang bis zum Ende ausgeführt  */
/* Die Klasse erweitert die Klasse Runnable um die Moeglichkeit die Kontrolle*/
/* an andere Coroutinen abzugeben.                                           */
/*****************************************************************************/

#ifndef __runnable_h__
#define __runnable_h__

/**
 * \class Runnable
 * \brief A flow of control.
 *
 * A Runnable is just an abstraction for a flow of control. The flow of control
 * itself can be specified by the user by implementing the action()-method.
 */
class Runnable {

public:

  /**
   * \brief Destructor
   *
   * Only needed to prevent compiler warnings due to virtual methods
   **/  
  virtual ~Runnable() {};

  /**
   * \brief A user-defined flow of control, t.m. a user-defined metod.
   */
  virtual void action() = 0;
};

#endif /* __runnable_h__ */
