/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*            S C H E D U L E R _ I M P L E M E N T A T I O N                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung des Schedulers.                                           */
/*****************************************************************************/

/* INCLUDES */

#include "interrupt/guard.h"
#include "interrupt/plugbox.h"

#include "object/queue.h"

#include "thread/scheduler_implementation.h"
#include "thread/thread.h"

/* GLOBALE VARIABLEN */

extern Guard guard;

/* IMPLEMENTIERUNG DER METHODEN */

void Scheduler_Implementation::start() {
  Thread* first;

  trigger_periodical();

  if(!active()) {
    first = peek();
    if(first) {
      go(first);
    }
  }
}

void Scheduler_Implementation::add(Thread* thread) {
  thread->init();
  enqueue(thread);
}

void Scheduler_Implementation::remove(Thread* thread) {
  remove(thread);
}

Thread* Scheduler_Implementation::schedule() {
  Thread* first_thread  = peek();
  Thread* active_thread = static_cast< Thread* >(active());

  clear_need_reschedule();

  if(first_thread == active_thread) {
    enqueue(dequeue());
  }

  return peek();
}

void Scheduler_Implementation::reschedule() {
  Thread* next_thread   = Scheduler_Implementation::schedule();
  Thread* active_thread = static_cast< Thread* >(active());

  if(next_thread && (next_thread != active_thread)) {
    dispatch(next_thread);
  }
}

void Scheduler_Implementation::yield() {
  set_need_reschedule();
}

void Scheduler_Implementation::exit() {
  dequeue();
  set_need_reschedule();

  /****************************************************************************
   * Idle-Loop                                                                *
   ****************************************************************************/
  while(1) {
    guard.leave();
    guard.enter();
  }
}

void Scheduler_Implementation::block(Thread* thread,Queue* queue) {
  thread->set_queue(queue);
  exit();
}

void Scheduler_Implementation::wakeup(Thread* thread) {
  thread->set_queue(0);
  enqueue(thread);
}

void Scheduler_Implementation::kill(Thread* thread) {
  Queue* queue;
  
  queue = thread->get_queue();

  // ein Thread toetet sich selbst

  if(thread == (Thread*)active()) {
    exit();
  }

  // Thread wartet auf ein Ereignis

  else if(queue) {
    queue->remove(thread);
    thread->set_queue(0);
  }

  // Thread befindet sich auf der Ready-Liste

  else {
    remove(thread);
  }
}

us_type Scheduler_Implementation::set_timeslice(us_type us) {
  return period(us);
}

us_type Scheduler_Implementation::get_timeslice() {
  return period();
}

// we always want to queue a dsr
bool Scheduler_Implementation::isr() {
  acknowledge();
  return true;
}

void Scheduler_Implementation::dsr() {
  yield();
}
