.PHONY: debug dbgstub

LIBSPICBOARDDIR ?= /proj/i4spic/pub/i4

CC   := avr-gcc
SIZE := avr-size
GDB  := avr-gdb

# uncomment for use on Sunrays (broken!)
#USBRUN  := /opt/SUNWut/bin/utusbrun

AVARICE ?= /proj/i4spic/pub/tools/bin/avarice-static
AVRDUDE := avrdude

# port for the GDB stub
PORT := 4242

# Use this to enable UIDs as ports (for many studs on the same host)
#PORT    := $(shell echo $$((`id -u` % 65535)) )

COMMONCFLAGS=-ffreestanding -mmcu=atmega32 -DF_CPU=1000000 -Wall -Werror -pedantic -pedantic-errors -I$(LIBSPICBOARDDIR)

# can't use these because of crappy avr-libc headers
COMMONCFLAGS+=-ansi

# Use these for debugging...
CFLAGS ?= -g -Os $(COMMONCFLAGS)

# ...or these for an optimized code image
#CFLAGS ?= -Os $(COMMONCFLAGS)

LDFLAGS ?= -L$(LIBSPICBOARDDIR) -lspicboard


dbgstub:
	$(AVARICE) -2 -B '125 kHz' -j usb -P atmega32 localhost:$(PORT)

# Pseudotarget zum Flashen eines ELF-Binaries
%.elf.flash: %.elf
	$(AVARICE) -2 -B '125 kHz' -j usb -P atmega32 -f $< --erase -p

%.hex.flash: %.hex
	@if [ -n "`lsusb | grep 03eb:2103`" ]; then \
		$(AVARICE) -2 -B '125 kHz' -j usb -P atmega32 -f $< --erase -p ; \
	elif [ -n "`lsusb | grep 03eb:2104`" ]; then \
		$(AVRDUDE) -p m32 -B 8 -c avrisp2 -P usb -U flash:w:$< ; \
	else \
		echo '************************************' ; \
		echo '     Connect ISP or JTAG device.' ; \
		echo '************************************' ; \
	 	exit 1 ; \
	fi

%.flash: %.hex.flash
	

%.elf.debug: %.elf
	$(GDB) $<
	
%.debug: %.elf.debug
	

# avrdude can't cope with ELF
%.hex: %.elf
	avr-objcopy -O ihex -R .eeprom $< $@

%.elf: %.c
	$(CC) $(CFLAGS) -o $@ $^ $(LDFLAGS) 
	$(SIZE) $@

test.elf: test.c led.c

