/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              T E S T I N G                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Basic support for writing testcases.                                      */
/*****************************************************************************/

#ifndef __testing_h__
#define __testing_h__

#include "infra/types.h"

extern const char* __message__;

extern void BPanic();
extern void BTestOK();

#define Panic(x)							\
  __message__ = "Test failed: " x;					\
  BPanic()

#define TestOK(x)							\
  __message__ = "Test successful: " x;					\
  BTestOK()

/**
 * \brief Busy-Wait macro
 *
 * This waits for a certain amount of cycles.
 **/
#define DELAY(x)				\
  do {						\
    volatile ezstubs_uint32 i = x;		\
    while(i--);					\
  } while(0)

/**
 * \brief Check the test sequence
 * \param ref_seq The reference sequence against which the sequence augmented
 *                during the execution of the testcase should be compared
 * \param seq The sequence augmented during the execution of the testcase
 * \retval true The reference sequence and the augmented sequence match, they
 *              are identical
 * \retval false The reference sequence and the augmented sequence do not match, 
 *               they are not identical
 **/
extern bool check_sequence(const char* ref_seq,char* seq);

/**
 * \brief Initialize the sequence
 * \param ref_seq The reference sequence, used to determine the lenght of
 *                the sequence
 * \param seq     The sequence to be initialized
 **/
extern void init_sequence(const char* ref_seq,char* seq);

#endif /* __testing_h__ */
