/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            C o n s o l e                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Printing text on the NDS screen                                           */
/*---------------------------------------------------------------------------*/

#ifndef __devices_console_h__
#define __devices_console_h__

#include "infra/memory_mapped.h"
#include "infra/types.h"

/**
 * \brief Printing text on the GBA screen
 **/
class Console {
  Memory_Mapped< ezstubs_uint8,0x04000240 > VRAM_A_CR;
  Memory_Mapped< ezstubs_uint8,0x04000242 > VRAM_C_CR;
  Memory_Mapped< ezstubs_uint16,0x4000304 > POWERCNT;
  Memory_Mapped< ezstubs_uint32,0x04001000 > DISPCNT_SUB;
  Memory_Mapped< ezstubs_uint16,0x04001008 > SUB_BG0_CR;
  Memory_Mapped< ezstubs_uint16,0x04000012 > BG0VOFS;
  Memory_Mapped< ezstubs_uint32,0x04001000 > DISPCNT;
  Memory_Mapped< ezstubs_uint16,0x4000000 > BG0CNT;
//Memory_Mapped< ezstubs_uint16,0x400000C > BG2CNT;
//Memory_Mapped< ezstubs_uint16,0x400100C > BG2CNT_SUB;
  /**
   * \brief Initialization
   **/
  void init();
  void crlf();

 unsigned short xPos;
  unsigned short yPos;
  unsigned short scrollPos;
 
 volatile ezstubs_uint16 *textMap;
  
  unsigned char bgColor;
  unsigned char textColor;
  ezstubs_uint8 mode;
  ezstubs_uint16 orMask;
  ezstubs_uint16 consoleInitialised;
  ezstubs_uint16 fontStart;
  ezstubs_uint16 fontOffset;
  ezstubs_uint16 fontPal; 

protected:

  enum {
    WIDTH   = 32,
    VWIDTH  = 32,
    HEIGHT  = 24,
    VHEIGHT = 24
  };

public:

  enum DispProp	{
    DP_REVERSE
  };

  Console() {
  		
    init();
  }

  /**
   * \brief Print a single character on the GBA screen
   * \param c The character to be printed
   **/
  void print(char c);

  /**
   * \brief Emtpy the GBA screen
   **/
  void clear();

  void setProperty(DispProp property, short val);

  /**
   * \brief Set the cursor position
   * \param x The X-position
   * \param y The Y-position
   **/
  void setPosition(unsigned char x, unsigned char y);

  /**
   * \brief Get the cursor position
   * \param x The X-position
   * \param y The Y-position
   **/
  void getPosition(unsigned char *x, unsigned char *y);

  /**
   * \brief Scroll down the screen
   * \param val The number of lines to scroll down
   **/
  void scroll(short val);
};

extern Console console;

#endif /* __devices_console_h__ */
