/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                     M E M O R Y _ M A P P E D _ I O                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Zugriff auf IO-Register, die in den Adressraum eingeblendet sind.         */
/*---------------------------------------------------------------------------*/

#ifndef __memory_mapped_h__
#define __memory_mapped_h__

#include "types.h"

/**
 * \brief An abstraction of memory mapped registers
 *
 * This class enables to access memory mapped registers just like
 * variable, this is achieved by overloading the assignment and 
 * cast operators for this class. The first template parameter
 * specifies the type or the width of the memory mapped register
 * and the second parameter specifies the address of the memory
 * mapped register.
 **/
template < typename REGTYPE,ezstubs_addrword ADDRESS > class Memory_Mapped {
  
public:

  /**
   * \brief Assignment operator
   *
   * Every assignment to a Memory_Mapped-Object is intercepted and
   * redirected to an assignment to the corresponding memory area
   **/
  REGTYPE operator=(REGTYPE val) {
    *((REGTYPE*)ADDRESS) = val;
    return val;
  }

  operator REGTYPE () const {
    return *((REGTYPE*)ADDRESS);
  }

  operator REGTYPE& () {
    return *((REGTYPE*)ADDRESS);
  }  

};

#endif /* __memory_mapped_h__ */
