/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              P L U G B O X                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Abstraktion einer Interruptvektortabelle. Damit kann man die Adresse der  */
/* Behandlungsroutine fuer jeden Hardware-, Softwareinterrupt und jede       */
/* Prozessorexception festlegen.                                             */
/*****************************************************************************/

#ifndef __Plugbox_include__
#define __Plugbox_include__

#include "interrupt/gate.h"
#include "interrupt/vectors.h"

/**
 * \class Plugbox
 * \brief Manages the interrupt handlers for the different interrupt vectors.
 * \see Gate
 */
class Plugbox {
  
  enum { size = VECTORS_COUNT };

  /**
   * \brief The table of interrupt handlers.
   */
  Gate* map[VECTORS_COUNT];

public:
  
  enum { 
    VECTORS
  };

  /**
   * \brief Constructor
   * \see Panic
   *
   * Initializes the whole table with the default interrupt handler
   */
  Plugbox();
  
  /**
   * \brief Insert an interrupt handler.
   * \param slot The interrupt vector that is handled by the interrupt
   *             handler \arg gate points to.
   * \param gate A pointer to the interrupt handler.
   */
  void assign(unsigned int slot, Gate* gate);
  
  /**
   * \brief Get the interrupt handler for a certain interrupt vector.
   * \param slot The interrupt vector for which the current interrupt handler
   *             should be returned.
   * \return The interrupt handler for the given vector.
   */
  Gate* report(unsigned int slot);
  
};

extern Plugbox plugbox;

#endif
