# available architectures
ARCHITECTURES = h8

# Doxygen Programm 
DOXYGEN := doxygen

# Doxygen configuration file
DOXYGEN_CONF := make/doxygen.conf

# directory for source files
SRC_DIR        = .

# directory for  generated files and directories
GEN_DIR        = gen

# directory for object files
OBJ_DIR        = $(GEN_DIR)/obj

# directory for library files
LIB_DIR        = $(GEN_DIR)/lib

# directory for dependency files
DEP_DIR        = $(GEN_DIR)/dep

# EZStubs library file
LIB_FILE       = $(LIB_DIR)/libezstubs.a

# find sources
SRC = $(shell find $(SRC_DIR) -follow \( -name '*.cc' -or -name '*.s' -or -name "*.S" \) -not -path '*/tests/*')

# generate object files
OBJ = $(patsubst $(SRC_DIR)/%.cc,$(OBJ_DIR)/%.o,$(filter %.cc,$(SRC)))
OBJ += $(patsubst $(SRC_DIR)/%.s,$(OBJ_DIR)/%.o,$(filter %.s,$(SRC)))
OBJ += $(patsubst $(SRC_DIR)/%.S,$(OBJ_DIR)/%.o,$(filter %.S,$(SRC)))

# generate dependency files
DEP = $(patsubst $(SRC_DIR)/%.cc,$(DEP_DIR)/%.d,$(filter %.cc,$(SRC)))

STARTUPFILE = $(OBJ_DIR)/startup/crt0.o

LINK_SEPARATE = $(STARTUPFILE) $(TARGET_LINK_SEPARATE)

# testcase-stuff
TEST_SRC_DIR = tests

TEST_SRC  = $(shell find $(TEST_SRC_DIR) -name '*.cc')
TESTCASES = $(patsubst %.cc,%,$(TEST_SRC))
TEST_OBJ  = $(patsubst %.cc,%.o,$(TEST_SRC))
TEST_ELF  = $(patsubst %.o,%.elf,$(TEST_OBJ))

# Compiler etc.
CC        = $(TOOL_PATH)/bin/$(TARGET_PREFIX)gcc
CXX       = $(TOOL_PATH)/bin/$(TARGET_PREFIX)g++
LD        = $(TOOL_PATH)/bin/$(TARGET_PREFIX)ld
GDB       = $(TOOL_PATH)/bin/$(TARGET_PREFIX)gdb
AS        = $(TOOL_PATH)/bin/$(TARGET_PREFIX)as
AR        = $(TOOL_PATH)/bin/$(TARGET_PREFIX)ar
OBJCOPY   = $(TOOL_PATH)/bin/$(TARGET_PREFIX)objcopy
SIZE	  = $(TOOL_PATH)/bin/$(TARGET_PREFIX)size

COMMONFLAGS = -Wall -Os -g		\
	-fomit-frame-pointer		\
	-fdata-sections 		\
	-ffunction-sections 		\
	-nostdlib 			\
	-fno-zero-initialized-in-bss 	\
	-nostartfiles 			\

# Flags etc.
CFLAGS   = $(COMMONFLAGS)		\
	$(TARGET_CFLAGS)

CXXFLAGS = $(COMMONFLAGS)		\
	-fomit-frame-pointer 		\
	-fno-rtti 			\
	-fno-exceptions  		\
	$(TARGET_CXXFLAGS)

LDFLAGS  = --gc-sections 		\
	-static				\
	-T make/$(LDSCRIPT)		\
	$(TARGET_LDFLAGS)

GDBFLAGS = --command make/gdb.init $(TARGET_GDBFLAGS)
ASFLAGS  = $(TARGET_ASFLAGS)
ARFLAGS  = $(TARGET_ARFLAGS)

INCLUDE = -I . $(TARGET_INCLUDE)

LIBS = $(LIB_FILE) $(TARGET_LIBS)

ifndef VERBOSE
  Verb := @
endif
