/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            O _ S T R E A M                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Klasse O_Stream enthaelt die Definition des << Operators fuer die     */
/* wichtigsten der vordefinierten Datentypen und realisiert somit die        */
/* bekannte Ausgabefunktion der C++ iO_Stream Bibliothek. Zur Zeit wird die  */
/* Darstellung von Zeichen, Zeichenketten und ganzen Zahlen unterstuetzt.    */
/* Ein weiterer << Operator erlaubt die Verwendung von Manipulatoren.        */
/*                                                                           */
/* Neben der Klasse O_Stream sind hier auch die Manipulatoren hex, dec, oct  */
/* und bin fuer die Wahl der Basis bei der Zahlendarstellung, sowie endl     */
/* fuer den Zeilenumbruch definiert.                                         */
/*****************************************************************************/

#ifndef __object_o_stream_h__
#define __object_o_stream_h__

#include "object/strbuf.h"

/**
 * \brief The output stream class
 *
 * The O_Stream class is just responsible for formatting strings, numbers and
 * pointers, it is not  responsible for displaying them on some kind of screen.
 * The characters produced by the O_Stream class are collected in a 
 * String_Buffer.
 **/
class O_Stream : public String_Buffer {

public:

  /**
   * \brief Basis of the current numbering system
   **/
  int base;

  /**
   * \brief Constructor
   * Initially we use the decimal system
   **/
  O_Stream() : String_Buffer(),base(10) {}

  /**
   * \brief Output a single character
   * \param c The character to output
   **/
  O_Stream& operator<< (unsigned char c);

  /**
   * \brief Output a single character
   * \param c The character to output
   **/
  O_Stream& operator<< (char c);

  /**
   * \brief Display numbers
   * \param ival The number to be displayed
   **/
  O_Stream& operator<<(long ival);

  /**
   * \brief Display numbers
   * \param ival The number to be displayed
   **/
  O_Stream& operator<<(unsigned long ival);

  /**
   * \brief Display a pointer
   * \param ptr The pointer to be displayed
   **/
  O_Stream& operator<<(void* ptr);

  /**
   * \brief Display a zero terminated string
   * \param string The string to be displayed
   **/
  O_Stream& operator<<(const char* string);

  /**
   * \brief Call an appropriate manipulatpor function
   **/
  O_Stream& operator<<(O_Stream& (*f) (O_Stream&));
    
};

/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          M A N I P U L A T O R E N                        */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die folgenden Funktionen erhalten und liefern jeweils eine Referenz auf   */
/* ein O_Stream Objekt. Da die Klasse O_Stream einen Operator << fuer        */
/* derartige Funktionen definiert, koennen sie mit Hilfe dieses Operators    */
/* aufgerufen und sogar in weitere Eingaben eingebettet werden.              */
/* Aufgabe der Manipulatoren ist, die Darstellung der nachfolgenden Ausgaben */
/* zu beeinflussen, z.B durch die Wahl des Zahlensystems.                    */
/*---------------------------------------------------------------------------*/

/**
 * \brief Print a newline
 **/
O_Stream& endl(O_Stream& os);

/**
 * \brief Switch the numbering system to binary
 **/
O_Stream& bin(O_Stream& os);

/**
 * \brief Switch the numbering system to octal
 **/
O_Stream& oct(O_Stream& os);

/**
 * \brief Switch the numbering system to deccimal
 **/
O_Stream& dec(O_Stream& os);

/**
 * \brief Switch the numbering system to hexadecimal
 **/
O_Stream& hex(O_Stream& os);

/**
 * \brief Kernel output stream
 **/
extern O_Stream kout;

#endif /* __object_o_stream_h__ */
