/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              Q U E U E                                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung einer einfach verketteten Liste von Chain Objekten.       */
/* enqueue fuegt ein neues Element an das Ende der Liste an.                 */
/* dequeue entfernt das erste und remove das angegebene Element der Liste.   */
/* Initial ist die Liste leer.                                               */
/*****************************************************************************/

#ifndef __queue_include__
#define __queue_include__

#include "object/chain.h"

/**
 * \class Queue
 * \brief A simple queue class
 **/
class Queue {

protected:

  /**
   * \brief Pointer to the first element of the queue
   **/
  Chain* head;
  /**
   * \brief Pointer to the last element of the queue
   **/
  Chain** tail;

public:

  /**
   * \brief Constructor
   * Initially the queue is empty
   **/
  Queue () { head = 0; tail = &head; }

  /**
   * \brief Append an element at the end of the queue
   * \param item The element to be added.
   **/
  void enqueue(Chain* item);

  /**
   * \brief Add an element at the beginning of a queue.
   * \param item The element to be added.
   **/
  void push_back(Chain* item);

  /**
   * \brief Return the first element within the queue, but do not remove it.
   * \return The first element within the queue
   **/
  Chain* peek() { return head; }

  /**
   * \brief Return the first element within the queue and remove it.
   * \return The first element within the queue
   **/
  Chain* dequeue();

  /**
   * \brief Remove an element of the queue.
   * \param item The element that should be removed.
   **/
  void remove(Chain* item);
};

#endif

