#ifndef __init_priorities_h__
#define __init_priorities_h__

/**
 * \file init_priorities.h
 * 
 * Some preprocessor macros to be used with the gcc attribute init_priority.
 * The advantage of using those macros instead of hard coded numbers is that
 * order of object creation could be changed just by editing these macros,
 * otherwise all occurences of __attribute__ ((init_priority(X))) had to be
 * taken into account.
 **/

/**
 * \brief Initialisation of Interrupt system
 **/
#define INIT_PRIORITY_INTERRUPT   1000

/**
 * \brief Initialisation of the scheduler
 **/
#define INIT_PRIORITY_SCHEDULER   2000

/**
 * \brief Initialisation of the device system, ie. timers, alarms, ...
 **/
#define INIT_PRIORITY_DEVICES     3000

/**
 * \brief Initialisation of the application
 **/
#define INIT_PRIORITY_APPLICATION 4000

#endif /* __init_priorities_h__ */
