/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            D S R _ S t o r e                              */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Diese Klasse bewahrt die aktivierten DSRs auf, die nicht abgearbeitet     */
/* werden konnten, weil sie innerhalb eines geschuetzen Abschnitts aktiviert */
/* wurden.                                                                   */
/*****************************************************************************/

#include "devices/derivate.h"
#include "interrupt/dsr_store.h"
#include "interrupt/gate.h"

Gate* DSR_Store::remove_dsr() {
  Gate *item;
  
  cpu.disable_int();
  item = (Gate *)dsr_queue.dequeue();
  cpu.enable_int();
  return item;
}

bool DSR_Store::dsrs_pending() {
  return dsr_queue.peek() != 0;
}

void DSR_Store::relay(Gate *item) {
  if(item->queued()) {
    // ERROR: some kind of error handler, dsr can only be enqueued once
  }
  else{
    item->queued(true);
    dsr_queue.enqueue(item);
  }
  /**
   * Wenn wir hier die Interrupts wieder erlauben ist das
   * problematisch, evtl. muessen wir vorher noch den 
   * Stack wechseln => diese entscheidung in den Interrupt
   * Handler verlagern
   *
   * cpu.enable_int();
   **/
}
