
# gcc rules for translating the sources and building the library

$(OBJ_DIR)/%.o: $(SRC_DIR)/%.cc 
	@echo "CXX      $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi 
	$(Verb) $(CXX) $(CXXFLAGS) $(INCLUDE) -o $@ -c $< 

$(OBJ_DIR)/%.o: $(SRC_DIR)/%.c
	@echo "CC       $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi 
	$(Verb) $(CC) $(CFLAGS) $(INCLUDE) -o $@ -c $< 

$(OBJ_DIR)/%.o: $(SRC_DIR)/%.s 
	@echo "AS        $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi 
	$(Verb) $(AS)  $(ASFLAGS) -o $@  $<

$(OBJ_DIR)/%.o: $(SRC_DIR)/%.S
	@echo "CC        $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi 
	$(Verb) $(CC) $(CFLAGS) $(INCLUDE) -o $@ -c $<

$(LIB_FILE): $(OBJ) 
	@echo "AR        $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi
	$(Verb) $(AR) $(ASFLAGS) rcs $@ $(filter-out $(STARTUPFILE),$+)

# generating dependency files

$(DEP_DIR)/%.d: $(SRC_DIR)/%.cc 
	@echo "DEP       $@"
	@if test \( ! \( -d $(@D) \) \) ;then mkdir -p $(@D);fi 
	$(Verb) $(CXX) $(CXXFLAGS) -MM -MT $(OBJ_DIR)/$*.o -MT $@ -MF $@ $< $(INCLUDE) >/dev/null

# rules for building the testcases

showtests:
	@echo "available tests:"
	@echo -en " $(patsubst %.cc,%\n,$(TEST_SRC))"

buildtests: $(TEST_ELF)

%.o : %.cc
	@echo "CXX_TEST $@"
	$(Verb) $(CXX) $(CXXFLAGS) $(INCLUDE) -o $@ -c $<

%.h : %.sched
	@echo "GENERATE_SCHEDULE from $<"
	@thread/generate_schedule $<

%.elf : %.o $(LIB_FILE)
	@echo "LD_TEST   $@" 
	$(Verb) $(LD) $(LDFLAGS) -Map $*.map -o $@  $(LINK_SEPARATE) $< $(LIBS)

%: %.elf 

%.clean::
	rm -f $*.elf $*.o $*.srec $*.map

# generating doxygen documentation

doxygen:
	@if [ ! -e $(GEN_DIR) ];then mkdir $(GEN_DIR);fi 
	$(DOXYGEN) $(DOXYGEN_CONF)

# include the dependency rules

ifneq "$(findstring clean,$(MAKECMDGOALS))" "clean"
-include $(DEP)
endif
TESTRUNNER	 = tests/TestRunner/testrunner.pl

checkalltests_sim:
	perl $(TESTRUNNER) sim $(TEST_TIMEOUT) $(GDB_REMOTE_CMD) testreport.csv . 'local' $(TESTCASES)

checkalltests_target: $(TESTCHECK_TARGET)
	@echo "Not yet implemented!"

%.sim_check:
	perl $(TESTRUNNER) sim $(TEST_TIMEOUT) $(GDB_REMOTE_CMD) $*.csv . 'local' $*

%.target_check:
	@echo "Not yet implemented!"

.PHONY: %.sim_check %.target_check checkalltests_sim checkalltests_target