/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                       S T R I N G B U F F E R                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Klasse Stringbuffer stellt einen Puffer fuer die Sammlung von Zeichen */
/* zur Darstellung auf dem Bildschirm oder anderen Ausgabegeraeten bereit.   */
/* Die Ausgabe der Zeichen erfolgt, sobald der Puffer voll ist oder wenn     */
/* explizit die Methode flush() aufgerufen wird.                             */
/* Da Stringbuffer geraeteunabhaengig sein soll, ist flush() eine virtuelle  */
/* Methode, die von den abgeleiteten Klassen definiert werden muss.          */
/*****************************************************************************/

#ifndef __object_strbuf_h__
#define __object_strbuf_h__

#include "devices/text_output_device.h"
#include "infra/types.h"

/**
 * \brief A buffer for a collection of characters
 *
 * A buffer for characters used in conjunction with some kind of output
 * device. As soon as the buffer is full it is emptied automatically by
 * calling flush(), the methods in the buffer are then output to the
 * device.
 **/
class String_Buffer : public Text_Output_Device {

protected:

  ezstubs_uint8 buffer[Text_Output_Device::WIDTH];
  ezstubs_uint32 pos;

  /**
   * \brief Constructor
   * By default the string buffer is empty
   **/
  String_Buffer() : pos(0) {}

  
  /**
   * \brief Virtual Destructor
   * Prevent compiler warnings due to virtual methods
   **/
  ~String_Buffer() {}

  /**
   * \brief Add a character to the string buffer
   * \param c The character to be added
   * \see StringBuffer::flush()
   *
   * When the string buffer is empty it will be emptied by the method flush()
   **/
  void put(ezstubs_uint8 c);

public:

  /**
   * \brief Empty the string buffer
   *
   * Empties the string puffer and outputs the characters to some kind of display
   **/
  void flush();
};

#endif /* __object_strbuf_h__ */
