/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                              T _ Q U E U E                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* A templatized queue                                                       */
/*****************************************************************************/

#ifndef __t_queue_h__
#define __t_queue_h__

#include "object/queue.h"

/**
 * \class T_Queue
 * \brief The templatized variant of class Queue
 * \see Queue
 **/
template< class T > class T_Queue : protected Queue {
public:

  /**
   * \brief Append an element at the end of the queue
   * \param item The element to be added.
   **/
  void enqueue(T* item) {
    Queue::enqueue(item);
  }

  /**
   * \brief Add an element at the beginning of a queue.
   * \param item The element to be added.
   **/
  void push_back(T* item) {
    Queue::push_back(item);
  }

  /**
   * \brief Return the first element within the queue, but do not remove it.
   * \return The first element within the queue
   **/
  T* peek() { 
    return static_cast< T* >(Queue::peek());
  }

  /**
   * \brief Return the first element within the queue and remove it.
   * \return The first element within the queue
   **/
  T* dequeue() { 
    return static_cast< T* >(Queue::dequeue());
  }

  /**
   * \brief Remove an element of the queue.
   * \param item The element that should be removed.
   **/
  void remove(T* item) {
    Queue::remove(item);
  }
};

#endif /* __t_queue_h__ */
