/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                 M A I N                                   */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* The main-function, from here the user_main-function and the scheduler is */
/* started.                                                                  */
/*---------------------------------------------------------------------------*/

#include "devices/derivate.h"
#include "interrupt/guard.h"
#include "thread/guarded_scheduler.h"

/**
 * \brief The user-defined start function. 
 *
 * Here threads, mutex etc. are initialized etc.. This function has to be 
 * provided by the application and is called within a secured section. So
 * the unsecured interface of the kernel has to be used.
 */
void user_main(void);

/**
 * \brief The main()-function.
 *
 * From here the user-defined main()-function is called. Afterwards interrupts
 * are enabled and the scheduler is started. The function is treated as critical
 * section and therefore locked to avoid scheduling, when an aperiodic thread
 * is added within the user_main() function.
 */
int main() {
  guard.enter();

  user_main();

  /**
   * in presence of a scheduler, interrupts are enabled when scheduling the first
   * thread, enabling the interrupts here might have serious consequences when we
   * use the interrupt stack for starting up
   **/
  // cpu.enable_int();

  scheduler.start();

  return 0;
}
