/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          C O R O U T I N E                                */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung des Koroutinenkonzepts.                                   */
/*****************************************************************************/

#ifndef __Coroutine_include__
#define __Coroutine_include__

#include "thread/runnable.h"

/**
 * \class Coroutine
 * \brief Coroutine implementation
 *
 * A simple flow of control extended with coroutine features, t.m. switching
 * between is possible, after being interrupted a coroutine can be resumed
 * later.
 */
class Coroutine : public Runnable {

private:

  /**
   * the coroutine's current stack pointer
   **/
  void* tos;

  /**
   * the coroutine's initial stack pointer
   **/
  void* stack_base;

public:

  /**
   * \brief Constructor
   * \param tos Pointer to the top of this coroutine's stack.
   */
  Coroutine(void* tos);

  /**
   * \brief Destructor
   *
   * Only needed to prevent compiler warnings due to virtual methods
   **/
  virtual ~Coroutine() {}

  /**
   * \brief Initialize this coroutine.
   * \see init_context()
   *
   * Initializing means setting up the coroutines context, by calling 
   * init_context.
   */
  void init();

  /**
   * \brief Start this coroutine
   * \see Coroutine::init()
   * \see load_context()
   * \attention May only be called after calling Coroutine::init()
   *
   * Start this Coroutine by loading its context to the processor.
   */
  void go();

  /**
   * \brief Change the currently running coroutine.
   * \param next The coroutine to be executed next.
   * \see Coroutine::init()
   * \see Coroutine::go()
   * \see switch_context()
   * \attention May only be called if the context of coroutine \arg next
   *            is set up properly by Coroutine::init(), Coroutine::go()
   *            or Coroutine::resume()
   *
   * Saves the context of the currently running coroutine and restores the
   * coroutine \arg next.
   */
  void resume(Coroutine* next);
};

#endif
