/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                    S C H E D U L E R _ T H R E A D                        */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die scheduler-spezifische Thread-Implementierung                          */
/*****************************************************************************/

#ifndef __scheduler_thread_h__
#define __scheduler_thread_h__

#include "thread/coroutine.h"
#include "object/chain.h"
#include "object/queue.h"

class Scheduler_Thread : public Chain, public Coroutine {
         
  Queue* queue;

public:

  // KONSTRUKTOR: Initialisierung
  Scheduler_Thread(void* tos) : Coroutine(tos),queue(0) {}
  virtual ~Scheduler_Thread() {}

  // WAITING_IN: Abfrage des "Wartezimmers", in dem sich der
  //             "Kunde" befindet
  Queue* get_queue() {
    return queue;
  }
  
  // WAITING_IN: Setzen des "Wartezimmers"
  void set_queue(Queue *q) {
    queue = q;
  }
         
};

#endif /* __scheduler_thread_h__ */
