/*
 * Decompiled with CFR 0.152.
 */
package org.aspectix.IDLflex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aspectix.IDLflex.Debug;
import org.aspectix.IDLflex.IDLDefCompiler;
import org.aspectix.IDLflex.IDLOutputList;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.IDLflexMain;
import org.aspectix.IDLflex.IRBase;
import org.aspectix.IDLflex.IRObj.FimoObjectCreator;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.aspectix.IDLflex.IRObj.ObjectCreator;
import org.aspectix.IDLparser.ValidatingParser;
import org.aspectix.IDLparser.pub.IDLException;
import org.aspectix.IDLparser.pub.IDLNode;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.Repository;

public class IDLcompiler {
    private IDLDefCompiler comp;

    public IDLcompiler(String string) throws IDLflexException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("IDLflexMapping", string);
        hashtable.put("IDLflexIncludeID", IDLflexMain.argsInclude);
        hashtable.put("IDLflexExcludeID", IDLflexMain.argsExclude);
        int n = IDLflexMain.argsAttributes.names.length;
        int n2 = 0;
        while (n2 < n) {
            hashtable.put("DEF:" + IDLflexMain.argsAttributes.names[n2], IDLflexMain.argsAttributes.values[n2]);
            ++n2;
        }
        this.comp = new IDLDefCompiler(hashtable);
    }

    public static IDLObject getIDLObjects(String string) throws IDLflexException {
        if (string.startsWith("FILE:")) {
            return IDLcompiler.getFimoIDLObjects(string.substring(5));
        }
        if (string.startsWith("JAVAORBIDL:")) {
            return IDLcompiler.getJavaOrbIdlIDLObjects(string.substring(11));
        }
        if (string.startsWith("JAVAORBIOR:")) {
            return IDLcompiler.getJavaOrbIorIDLObjects(string.substring(11));
        }
        return IDLcompiler.getFimoIDLObjects(string);
    }

    public IDLOutputList generateCodeFiles(IDLObject iDLObject) throws IDLflexException {
        return this.generateCodeFiles(iDLObject, null);
    }

    public IDLOutputList generateCodeFiles(IDLObject iDLObject, String string) throws IDLflexException {
        return this.comp.generateCode(string, iDLObject, 1);
    }

    public IDLOutputList generateCodeStreams(IDLObject iDLObject) throws IDLflexException {
        return this.generateCodeStreams(iDLObject, null);
    }

    public IDLOutputList generateCodeStreams(IDLObject iDLObject, String string) throws IDLflexException {
        return this.comp.generateCode(string, iDLObject, 2);
    }

    public String executeGET(IDLObject iDLObject, String string) throws IDLflexException {
        return this.comp.util.getName(string, iDLObject);
    }

    public String executeGET(IDLObject iDLObject, String string, String string2) throws IDLflexException {
        IDLObject iDLObject2 = this.lookupIDLName(iDLObject, string);
        return this.comp.util.getName(string2, iDLObject2);
    }

    public IDLObject lookupIDLName(IDLObject iDLObject, String string) throws IDLflexException {
        IDLObject iDLObject2 = iDLObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            IDLObject[] iDLObjectArray = iDLObject2.getContentList("MEMBER");
            int n = 0;
            while (n < iDLObjectArray.length) {
                if (iDLObjectArray[n].getName("name").equals(string2)) {
                    iDLObject2 = iDLObjectArray[n];
                    break;
                }
                ++n;
            }
            if (n < iDLObjectArray.length) continue;
            throw new IDLflexException("Element named " + string + " not found");
        }
        return iDLObject2;
    }

    private static IDLObject getJavaOrbIdlIDLObjects(String string) throws IDLflexException {
        Repository repository = IDLcompiler.getExternalIR(string);
        return IDLcompiler.getFromRepository(repository);
    }

    private static IDLObject getJavaOrbIorIDLObjects(String string) throws IDLflexException {
        Repository repository = IDLcompiler.resolve_ir(string);
        return IDLcompiler.getFromRepository(repository);
    }

    private static IDLObject getFromRepository(Repository repository) throws IDLflexException {
        IDLObject iDLObject = null;
        try {
            iDLObject = ObjectCreator.get((IRObject)repository);
        }
        catch (Exception exception) {
            Debug.print(1, exception);
            throw new IDLflexException("IDLcompiler: reading from IR repository failed:\n" + exception.getMessage());
        }
        return iDLObject;
    }

    private static Repository getExternalIR(String string) throws IDLflexException {
        IRBase iRBase = null;
        Debug.print(2, 1, ">> IDLcompiler: Creating interface repository from file " + string);
        try {
            Class<?> clazz = Class.forName("org.aspectix.IDLflex.IR_JavaORB");
            iRBase = (IRBase)clazz.newInstance();
            Repository repository = iRBase.create_repository(string);
            Debug.print(2, 1, ">> IDLcompiler: Using JavaORB Interface Repository");
            return repository;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                Class<?> clazz = Class.forName("org.aspectix.IDLflex.IR_ORBacus");
                iRBase = (IRBase)clazz.newInstance();
                Repository repository = iRBase.create_repository(string);
                Debug.print(2, 1, ">> IDLcompiler: Using ORBacus Interface Repository");
                return repository;
            }
            catch (Throwable throwable2) {
                throw new IDLflexException("Cannot feed " + string + " to internal repository:\nUnable to use either JavaORB or ORBacus IR tool");
            }
        }
    }

    private static Repository resolve_ir(String string) throws IDLflexException {
        throw new IDLflexException("not implemented");
    }

    private static IDLObject getFimoIDLObjects(String string) throws IDLflexException {
        Object object;
        int n;
        Object object2;
        IDLNode iDLNode = null;
        ValidatingParser validatingParser = new ValidatingParser();
        if (Debug.verbose(1) >= 2) {
            validatingParser.setVerbose();
        }
        try {
            object2 = "gcc -x c++ -E " + IDLflexMain.argsHandon + " -nostdinc -nostdinc++ -I- -undef";
            if (object2 != null) {
                n = 0;
                while (n < IDLflexMain.argsIDLInclude.size()) {
                    object2 = (String)object2 + " -I" + (String)IDLflexMain.argsIDLInclude.elementAt(n);
                    ++n;
                }
                Runtime runtime = Runtime.getRuntime();
                Debug.print(2, 1, "calling " + (String)object2 + " " + string);
                Process process = runtime.exec((String)object2 + " " + string);
                Debug.print(2, 1, "Preprocessor terminated");
                final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            if (bufferedReader.ready()) {
                                String string = bufferedReader.readLine();
                                System.out.println("Fehler beim Compiliervorgang!");
                                System.out.println(string);
                                while (bufferedReader.ready()) {
                                    string = bufferedReader.readLine();
                                    System.out.println(string);
                                }
                                bufferedReader.close();
                                System.exit(1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                object = process.getInputStream();
            } else {
                object = new FileInputStream(string);
            }
            Debug.print(2, 1, "Preprocessing done, starting parser");
            iDLNode = validatingParser.parse((InputStream)object);
            Debug.print(2, 1, "Parser returned.");
            if (Debug.verbose(1) >= 2) {
                validatingParser.printTreeInfo();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IDLflexException("IDLcompiler: file not found: " + string);
        }
        catch (IOException iOException) {
            throw new IDLflexException("IDLcompiler: reading " + string + " failed:\n" + iOException.getMessage());
        }
        catch (IDLException iDLException) {
            Debug.print(1, iDLException);
            throw new IDLflexException("IDLcompiler: parsing " + string + " failed:\n" + iDLException.getMessage());
        }
        object2 = null;
        try {
            object2 = FimoObjectCreator.get(iDLNode);
            object = new File(string).getName();
            n = ((String)object).indexOf(46);
            if (n > 0) {
                object = ((String)object).substring(0, n - 1);
            }
            ((IDLObject)object2).setName("name", (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IDLflexException("IDLcompiler: parsing " + string + " failed due to these errors:\n" + exception.getMessage());
        }
        return object2;
    }
}

