#ifndef __Message_h__
#define __Message_h__

#include <sys/types.h>
#include <cstdlib>

#include "Buffer.hpp"

class ResizeHandler {
  public:
    virtual void resize (Buffer *oldBuffer) = 0;
    virtual ~ResizeHandler () {}
};

class MyResizeHandler : public ResizeHandler {
  public:
    virtual void resize (Buffer *oldBuffer);
};

class Message {
  public:
    Message (Buffer *buffer);
    bool write (int8_t c);
    bool write (int16_t s);
    bool write (int32_t d);
    bool read (int8_t &c);
    bool read (int16_t &s);
    bool read (int32_t &d);
    void reset (); //set buffer position to 0
    Buffer *getBuffer ();
    void register_resize_handler (ResizeHandler *hndl);
  private:
    Buffer* myBuffer;
    int pos;
    ResizeHandler *resHandler;
    bool littleEndian;
    
    bool writeBytes(char* bytes, int number);
    bool readBytes(char* bytes, int number);
};


#endif
