" Vim syntax file
" Language:	AspectC++ ( http://www.aspectc.org/ )
" Author: Hengelein Stefan
" Last Change:	2013 May 8
"
" AspectC++ extends cpp by aspects
" inspired by '/usr/share/vim/vim73/syntax/*' files
"

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" Read the C++ syntax to start with
if version < 600
  so <sfile>:p:h/cpp.vim
else
  runtime! syntax/cpp.vim
  unlet b:current_syntax
endif

" AspectC++ extentions
syn keyword joinPointStatement call execution construction destruction before after around order
syn keyword pointcutStatement cflow base derived within that target result args
syn keyword aspectStatement that tjp
syn keyword aspectType pointcut advice
syn keyword aspectStructure aspect slice

"syn keyword apiSpecificTypes JoinPoint Result That Target thisJoinPoint
"syn keyword apiSpecificFunctions proceed trigger action aspectof signature type resulttype line


" Default highlighting
if version >= 508 || !exists("did_aspectcpp_syntax_inits")
  if version < 508
    let did_aspectcpp_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif
  HiLink aspectStructure		Structure
  HiLink aspectStatement		Keyword
  HiLink aspectType				Type
  HiLink joinPointStatement		Function		" TODO use Operator here?
  HiLink pointcutStatement		Function		" TODO use Operator here?

"  HiLink apiSpecificTypes		Type
"  HiLink apiSpecificFunctions	Operator

  delcommand HiLink
endif

let b:current_syntax = "aspectcpp"
