package de.fau.spicsim.gui;
/**
 * SiebenSegmentAnzeige
 * by Christian Götz
 * 27.02.2007
 *
 *
 * Eine Siebensegmentanzeige in Form einer Swingkomponente
 * Das ideale Größenverhältnis der Anzeige ist width/height = 12/20
 * http://www.java-forum.org/allgemeine-java-themen/42646-7-segment-anzeige.html
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.*;

public class SevenSeg extends Component {

	private static final long serialVersionUID = 7364720260424088546L;

	public static final float MIN_WIDTH = 12, MIN_HEIGHT = 20;

	private Color[] segment = {Color.gray, Color.gray, Color.gray,Color.gray, Color.gray, Color.gray, Color.gray};

	public SevenSeg()
	{
		super();
		init();
	}

	private void init()
	{
		setForeground(Color.RED);
		setSize((int)MIN_WIDTH, (int)MIN_HEIGHT);
		setPreferredSize(new Dimension((int)MIN_WIDTH*2, (int)MIN_HEIGHT*2));
		setMinimumSize(new Dimension((int)MIN_WIDTH, (int)MIN_HEIGHT));
	}

	/** schaltet ein einzelnes Segment (0-6) ein oder aus
	 *
	 * @param segment  das Segment das geschaltet werden soll
	 * @param col  true schaltet das Segment ein, false aus.
	 */
	public void setSegment(int segment, Color col)
	{
		if(this.segment[segment].equals(col)) return;
		this.segment[segment] = col;
		repaint();
	}

	/** schaltet alle 7 Segmente an oder aus.
	 *
	 * @param col  true schaltet die Segmente ein, false aus.
	 */
	public void setAllSegments(Color col)
	{
		for (int i=0 ; i<7 ; i++)
		{
			setSegment(i, col);
		}
		repaint();
	}

	@Override
	public void paint(Graphics gr)
	{
		Graphics2D g = (Graphics2D) gr;
		g.setBackground(Color.black);
		g.clearRect(0, 0, getWidth(), getHeight());

		for(int i=0 ; i<segment.length ; i++)
		{
			paintSegment(g, i, segment[i]);
		}
	}

	private void paintSegment(Graphics2D g, int segment, Color col)
	{
		switch(segment)
		{
//			Horizontale Segmente:
			case 0:
				paintHorizontalSegment(g, 0, col);
			break;

			case 6:
				paintHorizontalSegment(g, 8, col);
			break;

			case 3:
				paintHorizontalSegment(g, 16, col);
			break;

//			Vertikale Segmente:
			case 5:
				paintVerticalSegment(g, 0, 0, col);
			break;

			case 1:
				paintVerticalSegment(g, 0, 8, col);
			break;

			case 4:
				paintVerticalSegment(g, 8, 0, col);
			break;

			case 2:
				paintVerticalSegment(g, 8, 8, col);
			break;
		}
	}

	private void paintHorizontalSegment(Graphics2D g, int row, Color col)
	{
		float space = 0.0f;
		if(getWidth() < getHeight()){
			space = getWidth()/80.0f;
		}else{
			space = getHeight()/80.0f;
		}

		float fieldWidth = getWidth()/12f;
		float fieldHeight = getHeight()/20f;

		Path2D.Float polygon = new Path2D.Float();
		polygon.moveTo(fieldWidth*2 + space, fieldHeight*2 + row*fieldHeight);
		polygon.lineTo(fieldWidth*3 + space, fieldHeight + row*fieldHeight);
		polygon.lineTo(fieldWidth*9 - space, fieldHeight + row*fieldHeight);
		polygon.lineTo(fieldWidth*10 - space, fieldHeight*2 + row*fieldHeight);
		polygon.lineTo(fieldWidth*9 - space, fieldHeight*3 + row*fieldHeight);
		polygon.lineTo(fieldWidth*3 + space, fieldHeight*3 + row*fieldHeight);
		polygon.lineTo(fieldWidth*2 + space, fieldHeight*2 + row*fieldHeight);

		if(col != null){
			g.setPaint(col);
			g.fill(polygon);
		}
	}

	private void paintVerticalSegment(Graphics2D g, int row, int column, Color col)
	{
		float space = 0.0f;
		if(getWidth() < getHeight()){
			space = getWidth()/80.0f;
		}else{
			space = getHeight()/80.0f;
		}
		float fieldWidth = getWidth()/12f;
		float fieldHeight = getHeight()/20f;

		Path2D.Float polygon = new Path2D.Float();
		polygon.moveTo(fieldWidth*2 + column*fieldWidth, fieldHeight*2 + row*fieldHeight + space);
		polygon.lineTo(fieldWidth*3 + column*fieldWidth, fieldHeight*3 + row*fieldHeight + space);
		polygon.lineTo(fieldWidth*3 + column*fieldWidth, fieldHeight*9 + row*fieldHeight - space);
		polygon.lineTo(fieldWidth*2 + column*fieldWidth, fieldHeight*10 + row*fieldHeight - space);
		polygon.lineTo(fieldWidth + column*fieldWidth, fieldHeight*9 + row*fieldHeight - space);
		polygon.lineTo(fieldWidth + column*fieldWidth, fieldHeight*3 + row*fieldHeight + space);
		polygon.lineTo(fieldWidth*2 + column*fieldWidth, fieldHeight*2 + row*fieldHeight + space);

		if(col != null){
			g.setPaint(col);
			g.fill(polygon);
		}
	}

}