Logic Analyzer
==============

Ein einfacher [Logikanalysator](https://de.wikipedia.org/wiki/Logikanalysator) für das [Kommunikationsmodul](https://www4.cs.fau.de/Lehre/WS17/V_GSPIC/Uebungen/doc/group__COM.shtml) des SPiCboards.
Dieser kann als visuelle Hilfe zur Fehlerbehebung fungieren.

![Anzeige](./screenshot/analyzer.png)


Verwendung
----------

Das SPiCboard muss entsprechend über die serielle Schnittstelle verbunden werden.

Mit dem oberen Taster (`BTN1`) wird der Empfang aktiviert, die Aufzeichnung beginnt mit der nächsten Pegeländerung auf `RX`/`PD0` und wird auf der OLED-Anzeige graphisch aufbereitet. Mit dem Drehpotentiometer kann das für die Auswertung des Datenwortes relvante Empfangsfenster angepasst werden.

Ebenfalls ändert das Drehpotentiometer die auf der 7-Segmentanzeige dargestellte Hexzahl auf einen Wert zwischen `00` und `FF`. Beim Druck auf den unteren Taster (`BTN0`) wird dieser Wert über `TX`/`PD1` gesendet, der Sendeverlauf wird auch auf der OLED-Anzeige dargestellt.

Beim Empfangen und Senden signalisieren die oberen und unteren LED-Quadrupel den aktuellen Zustand:

  * **rot**: Übertragung pausiert (beendet)
  * **gelb**: Bereit für Übertragung (bei Empfang warten auf Pegeländerung)
  * **grün**: Übertragung aktiv
  * (**blau** wird nicht verwendet)


Anzeige
-------

![Aufteilung](./screenshot/aufteilung.png)

 * Die hexadezimale Zahl hinter `Recv` in der ersten Zeile gibt den empfangenen Wert an der derzeit ausgewählten Position an, z.B. `Recv x17` zeigt den Empfang der (dezimalen) Zahl 23 an (≙ 17₁₆). Nicht eindeutig dekodierbare Daten werden mit `Recv ??` gekennzeichnet.
 * Anschließend wird ein korrektes (gerades) [Paritätsbit](https://de.wikipedia.org/wiki/Parit%C3%A4tsbit) mit einem `P ♥` visualisiert, ein falsches mit  `P !` und ein nicht eindeutiges Signal mit `P ?`
 * Sofern Anfangs-/Start- und End-/Stopbit korrekt sind, wird nachfolgend `S ♥` angezeigt, bei einem oder zwei falschen Pegel `S !` bzw `S ‼` und uneindeutige Signale mit `S ?`
 * Darunter folgt die Einteilung der Zeitachse für den Graphen - das Datenfenster ist mit einzelnen Zeichen markiert:
     * **A**: Anfangs- bzw Startbit
     * **0** bis **7**: Datenbits
     * **P**: Paritätsbit
     * **E**: End- bzw Stopbit
 * Der Graph selbst wird mit einer Auflösung von acht binären Abtastpunkten (hoher oder niedriger Pegel) pro Symbol angezeigt. Auf dem Display können nur 16 Symbole gleichzeitig angezeigt werden, das Potentiometer erlaubt ein Verschieben des Empfangsfensters - die dekodierten Werte in der ersten Zeile werden entsprechend angepasst.
 * Die Binärwerte des dem jeweiligen Graphabschnitt entsprechenden Symbols werden nochmals in der Skala in der nachfolgenden Zeile angezeigt, eine `1` entspricht einem hohen Pegel, eine `0` einem niedrigen und eine ausgelassene Beschriftung einem nicht eindeutigen Bit.
 * In der letzten für den Empfang relevanten Zeile wird eine Übersicht über den vollständigen Graph sowie die derzeit aktive Ansicht (dicker Unterstrich) angezeigt.
 * Der untere Graph ist eine Darstellung über den Sendeverlauf, die Skala ist analog zu dem Empfangsverlauf, es werden jedoch nur die ersten 16 Symbole des jeweils letzten gesendeten Wertes dargestellt.
 * Die entsprechenden Binärwerte werden in der darunterliegenden Skala nochmals mit `1` für einen hohen und `0` für einen niedrigen Pegel angezeigt.


Hinweise
--------

Die [Symbolrate](https://de.wikipedia.org/wiki/Symbolrate) ist mit 1200 Baud vordefiniert, kann aber bei der Übersetzung durch Überschreiben der Variable `BAUD_RATE` angepasst werden.

Aufgrund der eingeschränkten Auflösung des Potentiometers ist der Empfangsbuffer auf 255 Symbole beschränkt, da sonst eine genau Navigation der Position des empfangenen Datenfensters nicht möglich wäre.
