echo off
echo ; set +v # > NUL
echo ; GOTO() { true; } # > NUL
GOTO WIN
if ! command -v avrdude 2>/dev/null 2>&1 ; then /bin/echo -e "\t\e[41;37;1m AVRDUDE not installed! \e[0m" #
	/bin/echo -e "Please install it from\n\thttp://savannah.nongnu.org/projects/avrdude\nor using the software package of your linux distributor.\nOn Debian/Ubuntu:\n\tsudo apt install avrdude" #
	exit 1 # 
elif ! lsusb -d 03eb:2145 >/dev/null 2>&1 ; then /bin/echo -e "\t\e[41;37;1m SPiCboard not found! \e[0m" #
	echo "Please connect your SPiCboard v3 via USB and retry." #
	exit 1 #
else tmpdev="$(mktemp)" #
	/bin/echo -e 'part parent "m328"\n    id                  = "m328pb";\n    desc                = "ATmega328PB";\n    signature           = 0x1e 0x95 0x16;\n    ocdrev              = 1;\n;' > "$tmpdev" #
	for f in *.elf #
	do #
		if avrdude -p m328pb -c xplainedmini -P usb -C +"$tmpdev" -U flash:w:$f ; then /bin/echo -e "\e[1mProgram $f flashed\e[0m" #
			read -r -p "Press enter to continue..." key #
		else #
			exit $? #
		fi #
	done #
	rm "$tmpdev" #
	exit 0 #
fi #

:WIN

for %%f in (*.elf *.hex) do (
    "C:\Program Files (x86)\Atmel\Studio\7.0\atbackend\atprogram.exe" -t medbg -d atmega328pb -i debugWIRE program --verify -f %%f
    if errorlevel 14 (
        "C:\Program Files (x86)\Atmel\Studio\7.0\atbackend\atprogram.exe" -t medbg -d atmega328pb -i ISP program -c --verify -f %%f
    )
    IF %ERRORLEVEL% NEQ 0 (
        exit /b %%errorlevel%%
    ) else (
        echo Program %%f flashed
        pause
    )
)
