SPiC Mario
==========

Ein fast vollständiges Mariospiel für das SPiCboard.
![Startbildschirm](./screenshots/startbildschirm.png)

Features
--------

* Verschiedene Gegnerarten:
	- Böse Pilze (Evil Mushrooms)
	- Rohre mit giftigen Pflanzen
	- Löcher im Boden
	- Plötzlich auftretende Risse
* Verschiedene Arten Punkte zu verdienen:
	- Münzen
	- Zertrampeln von bösen Pilzen
	- Sterne
	- Gutartige Pilze
* verschiedene Level mit steigender Schwierigkeit
* Tutorial
* persistenter Highscore

Steuerung
---------

Mit Hilfe des Potentiometers kann gesteuert werden, ob sich Mario nach rechts oder links bewegen soll. Alternativ kann er auch stehen bleiben, während die Welt weiterläuft.

Wenn man den `BUTTON0` drückt, springt Mario und kann so Gegner ausweichen und böse Pilze zertrampeln.

Wenn man Münzen einsammelt, Gegner zertrampelt oder Pilze und Sterne findet, kann man Punkte sammeln. Die Punkte werden am Ende eines Levels mit dem Schwierigkeitsgrad verrechnet und zu deiner Gesamtpunktzahl zusammengefasst. Während eines Levels gibt es nur eine bestimmmte Zahl von Möglichkeiten Punkte zu sammeln, versuche also keine auszulassen, um den Highscore zu knacken.
![Spielszene](./screenshots/spielszene.png)

Das Ende eines Levels wird durch eine Flagge angezeigt. Man muss die Flagge berühren, um das Level zu beenden. Danach startet das nächste Level mit erhöhter Schwierigkeit:
- mehr Gegner
- giftige Blumen bleiben länger sichtbar
- Mario wird müder und kann nicht mehr so lange springen
- ab Level 3 können Löcher nicht nur von rechts in die Spielwelt gelangen, sondern können auch plötzlich unter Mario aufreißen. Beeile dich um nicht hinein zu fallen!

![Levelszene](./screenshots/levelende.png)

Weitere Ideen
-------------

Mit den implementierten Features läuft der Prozessor nahe am Anschlag (das Schlafen ist inzwischen deaktiviert). Damit sind 18 Spielticks pro Sekunde möglich, was eine flüssige Darstellung und einen angenehmen Schwierigkeitsgrad ermöglicht.

Im Moment sind etwa 620 Bytes des SRAMs für Zustand und globale Variablen benutzt, der Rest der 2K bleibt für den Stack. Viel weniger sollte es auch nicht für den Stack sein. Einige der Sprites liegen aber im Moment noch im SRAM, die könnte man in den Flash verschieben.

Vom Flash sind im Moment ungefähr 22K von den 32K belegt, hier hätte man also noch Platz Sachen auszulagern.

**Ideen:**
- Mario eine Möglichkeit zum Schießen zu geben
- In die Rohre klettern
- Mehr Gegnerarten (Schildkröten, ...)
- Prinz/Prinzessin zum Retten hinzufügen
- Endgegner hinzufügen
- Berge/Hügel hinzufügen
- ...

Struktur
--------

* **[assets](./assets/)** Gimp und `PNG` Dateien für die Sprites.
* **[bitmaps](./bitmaps/)** `C` Arrays mit den Sprites in Binärform. Erzeugt aus den `PNG` Dateien im `assets` Ordner.
* **[tools](./tools/)** Ordner für tools. Enthält ein Tool, um aus PNGs Binärdarstellungen zu machen, die mit der libspicboard `sb_display_drawBitmap*()` Funktionsfamilie harmonieren.
* **[screenshots](./screenshots/)** Beispiele aus dem Spiel.

