Morse-Code Übersetzer
=====================

Übersetzt empfangene [Morsezeichen](https://de.wikipedia.org/wiki/Morsezeichen) (bis zu einer Länge von sechs Symbolen) in Klartext-Buchstaben/Sonderzeichen.


Verwendung
----------

Mit dem Taster auf `PD2` (`BUTTON0`) werden Morsezeichen eingegeben, die dann auf der [7-Segmentanzeige](https://www4.cs.fau.de/Lehre/current/V_SPIC/Uebungen/doc/group__SEG.shtml), dem [OLED-Display](https://www4.cs.fau.de/Lehre/current/V_SPIC/Uebungen/doc/group__Display.shtml) und der [seriellen Konsole](https://www4.cs.fau.de/Lehre/current/V_SPIC/Uebungen/doc/group__Console.shtml) ausgegeben werden.

Es werden standardmäßig Morsezeichen bis fünf Stellen erkannt - allerdings können durch Definieren des `MORSE_PUNCTUATION`-Makros auch sechs-stellige Zeichen übersetzt werden (trotz der theoretisch 64 Möglichkeiten beinhaltet dies nur 12 Symbole - primär Satzzeichen).

Die Eingabegeschwindigkeit wird durch das Makro `THRESHOLD` bestimmt. Der Defaultwert ist 60, kann aber bei Anfängern erhöht werden, um die Eingabe durch mehr Zeit pro Symbol zu erleichtern.

Für die Eingabe im Morsecode gilt:

 * ein langes Signal (Strich) soll drei Mal die Dauer eines kurzen Signals (Punkt) haben.
 * die Pause zwischen zwei Symbolen (des selben Buchstaben) soll die Dauer eines kurzen Signals haben
 * um zwei Buchstaben zu trennen soll die Pause die Dauer eines langen Signals (d.h. drei Mal kurzes Signal) sein
 * ein Leerzeichen, dass zwei Wörter trennt, soll die Dauer von sieben kurzen Signalen haben

Die LEDs unterstützen wie folgt die Eingabe:

 * die unterste blaue LED (`BLUE1`) leuchtet beim Drücken der Taste
 * die beiden nächsten LEDS (`GREEN1` und `YELLOW1`) leuchten auf sobald der Tastendruck als langes Signal zählt
 * die rote LED in der Mitte (`RED1`) signalisiert ein ungültiges Morsecodezeichen
 * die gelbe LED (`YELLOW0`) leuchtet sobald die Pause als Symbolabstand gezählt wird
 * und wird von der grünen LED (`GREEN0`) abgelöst, wenn die Pause lange genug für einen Wortabstand ist

![Startbildschirm](./screenshot/morse-1.png)
![Im Betrieb](./screenshot/morse-2.png)


Anmerkung
---------

Die Auflösung der Morsezeichen geschieht mit Hilfe eines [Morsebaums](https://commons.wikimedia.org/wiki/File:Morse_code_tree3.png#/media/File:Morse_code_tree3.png), welcher mittels [binären Heaps](https://de.wikipedia.org/wiki/Bin%C3%A4rer_Heap) als flache Zeichenkette gespeichert wird.


Erweiterungsmöglichkeiten
-------------------------

 * statt Taster den Lichtsensor oder `COM`-Port verwenden
 * dynamische Erkennung der Geschwindigkeit
