#ifndef _BOARD_H
#define _BOARD_H

#include <stdint.h>
#include <stdbool.h>

#define TILE_SIZE 8
#define BOARD_HEIGHT 8
#define BOARD_WIDTH 16
#define POS_PACMAN_X 0
#define POS_PACMAN_Y 0
#define POS_GHOST_X 15
#define POS_GHOST_Y 7

#define DEADLY_DISTANCE (TILE_SIZE * TILE_SIZE / 2)


const __flash uint16_t board[BOARD_HEIGHT] = {
	BINARY(0000000101000001),
	BINARY(0111110000010100),
	BINARY(0100000111011110),
	BINARY(0111110100000100),
	BINARY(0001000111110101),
	BINARY(0111110100010100),
	BINARY(0000000101110001),
	BINARY(0101010000000100)
};

const __flash uint16_t special_dots[BOARD_HEIGHT] = {
	BINARY(0000000010000000),
	BINARY(0000000000000000),
	BINARY(0000000000000000),
	BINARY(0000000000001000),
	BINARY(0000000000000000),
	BINARY(0000000000000000),
	BINARY(0000100000000000),
	BINARY(0000000000001000)
};

#endif
