#ifndef _MONSTERS_H
#define _MONSTERS_H

#include <stdint.h>

#define MAX_DEV_VAL 0x3FF
#define MAX_SPEED 0x50 /* small values => fewer overflows from timer needed to actualize the position */
#define MIN_SPEED 0x300

typedef enum {
	EVENT_CHANGE_DIR = 1,
	EVENT_ACT_P_POS = 2,
	EVENT_ACT_G_POS = 4,
	EVENT_WAIT = 5
} EVENT;


typedef enum {
	RIGHT,
	DOWN,
	LEFT,
	UP
} DIRE;


typedef enum { 
	NORMAL = 0,
	ROTATE_1 = 1,
	ROTATE_2 = 2,
	ROTATE_3 = 4, 
	MIRROR_V = 8,
	MIRROR_H = 16
} BIAS;

typedef enum { 
	START,
	HALT, 
	PLAY,
	END
} STATE;

typedef struct {
	int8_t dir;
	int8_t next_dir;
	uint8_t px; //range 128 
	uint8_t py; //range 64
	uint8_t dead;
} position;

const __flash uint8_t wall[8] = {
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111),
	BINARY(11111111)
};

const __flash uint8_t dot[8] = {
	BINARY(00000000),
	BINARY(00011000),
	BINARY(00111100),
	BINARY(01100110),
	BINARY(01100110),
	BINARY(00111100),
	BINARY(00011000),
	BINARY(00000000)
};

const __flash uint8_t dot_filled[] = {
	BINARY(00000000),
	BINARY(00011000),
	BINARY(00111100),
	BINARY(01111110),
	BINARY(01111110),
	BINARY(00111100),
	BINARY(00011000),
	BINARY(00000000)
};

const __flash uint8_t pacman_bm[][8] = {
	{
		BINARY(00111100),
		BINARY(01110110),
		BINARY(11110011),
		BINARY(11011111),
		BINARY(11100000),
		BINARY(11111111),
		BINARY(01111110),
		BINARY(00111100)
	},
	{
		BINARY(00111100),
		BINARY(01100110),
		BINARY(11111111),
		BINARY(11010101),
		BINARY(11101010),
		BINARY(11111111),
		BINARY(01111110),
		BINARY(00111100)
	},
	{
		BINARY(00111100),
		BINARY(01101110),
		BINARY(11110101),
		BINARY(11000000),
		BINARY(11100000),
		BINARY(11110101),
		BINARY(01111110),
		BINARY(00111100)
	},
	{
		BINARY(00111100),
		BINARY(01111111),
		BINARY(11110101),
		BINARY(11000000),
		BINARY(11100000),
		BINARY(11110000),
		BINARY(01111111),
		BINARY(00111100)
	}
};

const __flash uint8_t ghost_bm[][8] = {
	{
		BINARY(00111100),
		BINARY(01111110),
		BINARY(11101101),
		BINARY(11001001),
		BINARY(11111111),
		BINARY(11011101),
		BINARY(11001101),
		BINARY(10001001)
	},
	{
		BINARY(00111100),
		BINARY(01011010),
		BINARY(10011001),
		BINARY(11111111),
		BINARY(11111111),
		BINARY(11011011),
		BINARY(10011011),
		BINARY(10001001)
	},
	{
		BINARY(00111100),
		BINARY(01111110),
		BINARY(11011011),
		BINARY(10011001),
		BINARY(11111111),
		BINARY(11011011),
		BINARY(10011011),
		BINARY(10010001)
	}
};

#endif
