#include <stddef.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "led.h"
#include "adc.h"
#include "com.h"

void main(){
	sei();
	uint8_t v = 0;
	sb_led_on(BLUE1);
	while (1){
		uint8_t i = 255 - sb_adc_read(POTI)/4;
		if (i != v){
			sb_com_sendByte(i);
			v = i;
		}
		_delay_ms(20);
	}
}
