package de.fau.spicsim.gui

import de.fau.spicsim.Main
import scala.collection.immutable.IndexedSeq
import java.awt.GridBagLayout
import java.awt.GridBagConstraints
import java.awt.Color
import java.awt.Dimension
import java.awt.Insets
import java.awt.Toolkit
import java.awt.Image
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.RenderingHints
import java.awt.Font
import javax.swing.JSlider
import javax.swing.SwingConstants
import javax.swing.AbstractButton
import javax.swing.JToggleButton
import javax.swing.JButton
import javax.swing.JLabel
import javax.swing.ImageIcon
import javax.swing.UIManager
import javax.swing.JFrame
import javax.swing.JPanel

abstract class MainWindow {

	val ledcol = List(Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE, Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE)

    val frame = new JFrame("SPiCsim v" + Main.boardVersion)
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
    frame.setBounds(100, 100, 520, 320)
    frame.setMinimumSize(new Dimension(520, 320))

    //Add leds
    val leds = for (i <- 0 to 7) yield {
        val led = new Led(ledcol(i))
        led
    }

    val adc = for (i <- 0 to 1) yield {
        val adc = new JSlider()
        adc.setOrientation(1)
        adc.setMinimum(0)
        adc.setMaximum(1024)
        adc
    }

    val btnLoad = new JButton("<html><center><b>Load program</b></center></html>")
    //btnLoad.setFont(new Font("Arial", Font.BOLD, 15))

    val btnReset = new JButton("<html><center><b>Reset microcontroller</b></center></html>")
    //btnReset.setFont(new Font("Arial", Font.BOLD, 15))

    val sSeg = for (i <- 0 to 1) yield {
        val seg = new SevenSeg
        seg
    }

    val btn: IndexedSeq[AbstractButton] = for (i <- 0 to 1) yield {
        val button = new JButton("<html><center><b>Button " + i + "</b></center></html>")
        //button.setFont(new Font("Arial", Font.BOLD, 15))
        button
    }

    def getImage(pathAndFileName : String) : Image = {
        val url = Thread.currentThread().getContextClassLoader().getResource(pathAndFileName);
        val image = Toolkit.getDefaultToolkit().getImage(url);
        return image;
    }
}
