/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                        T_ O R D E R E R D _ L I S T                       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Die Template-Variante einer sortierten Liste.                             */
/*****************************************************************************/

#ifndef __object_t_ordered_list_h__
#define __object_t_ordered_list_h__

#include "object/chain.h"
#include "object/ordered_queue.h"

/**
 * \brief The template-version of an ordered queue
 *
 * The elements in the queue are ordered due to a comparator
 * specified by a template parameter
 **/
template< typename T,class COMPARATOR > class T_Ordered_Queue 
  : protected Ordered_Queue < COMPARATOR > {
public:

  /**
   * \brief Inserts an item into the queue preserving the order
   *        with respect to the comparator
   * \param item The element to be added.
   **/
  void enqueue(T* item) {
    Ordered_Queue< COMPARATOR >::enqueue(item);
  }

  /**
   * \brief Return the first element within the queue and remove it.
   * \return The first element within the queue
   **/
  T* dequeue() {
    return static_cast< T* >(Ordered_Queue< COMPARATOR >::dequeue());
  }

  T* peek() {
    return static_cast< T* >(Ordered_Queue< COMPARATOR >::peek());
  }

  /**
   * \brief Remove an element of the queue.
   * \param item The element that should be removed.
   **/
  void remove(T* item) {
    Ordered_Queue< COMPARATOR >::remove(item);
  }
};

#endif /* __object_t_ordered_list_h__ */
