#include "debug/testing.h"

#include "devices/derivate.h"

#include "infra/utils.h"

#include "thread/guarded_scheduler.h"
#include "thread/thread.h"

const char* right_sequence = "abcdabcdabcd";
      char sequence[12];

volatile int counter = 0;

class Test_Thread : public Thread {

  static volatile unsigned char runs;
  static Thread* checker_thread;

  char thread_char;

public:

  Test_Thread(void* tos,char c) : Thread(tos),thread_char(c) {}

  void action() {
    while(1) {
      unsigned char temp_runs = ++runs;

      sequence[counter++] = thread_char;

      if(runs == 12) {
	scheduler.add(checker_thread);
      }

      if(runs > 8) {
	scheduler.exit();
      }

      while(temp_runs == runs);
    }
  }
};

class Checker_Thread : public Thread {

public:

  Checker_Thread(void* tos) : Thread(tos) {}

  void action() {
    cpu.disable_int();

    if(!check_sequence(right_sequence,sequence)) {
      Panic("Wrong Testsequence!");
    }

    TestOK("Test successful finished!");
  }
};

static unsigned int stack[4][256];

Test_Thread t1(&stack[1][0],'a');
Test_Thread t2(&stack[2][0],'b');
Test_Thread t3(&stack[3][0],'c');
Test_Thread t4(&stack[4][0],'d');

Checker_Thread checker(&stack[1][0]);

volatile unsigned char Test_Thread::runs = 0;
Thread* Test_Thread::checker_thread = &checker;

void user_main() {
  init_sequence(right_sequence,sequence);
  scheduler.add(&t1);
  scheduler.add(&t2);
  scheduler.add(&t3);
  scheduler.add(&t4);

  scheduler.set_timeslice(30000);
}
