/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                          D I S P A T C H E R                              */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Implementierung des Dispatcher.                                           */
/* Der Dispatcher verwaltet den life-Pointer, der die jeweils aktive         */
/* Koroutine angibt. mit go() wird der life Pointer initialisiert und die    */
/* erste Koroutine gestartet, alle weiteren Kontextwechsel werden mit        */
/* dispatch() ausgeloest. active() liefert den life Pointer zurueck.         */
/*****************************************************************************/

#ifndef __dispatch_h__
#define __dispatch_h__

#include "thread/coroutine.h"

/**
 * \class Dispatcher
 * \brief Switching between different Coroutines
 *
 * Dispatching between different coroutines, while keeping track of the 
 * currently running coroutine and managing the coroutines' contexts.
 */
class Dispatcher {

  /**
   * \brief The coroutine that currently is being executed.
   */
  Coroutine* life;

public:

  /**
   * \brief Constructor
   *
   * Initially no thread is running so life is initialized to 0
   **/
  Dispatcher() : life(0) {}

  /**
   * \brief Start a coroutine
   * \param first A pointer to the coroutine to be started.
   *
   * Load the context of the given coroutine and execute it.
   */
  void go(Coroutine* first);

  /**
   * \brief Switch to a different coroutine.
   * \param next The coroutine that should be executed next.
   * \see Coroutine::life
   *
   * Save the context of the currently executed coroutine, load the
   * context of the coroutine \arg next points to and execute it. The
   * pointer to currently executed coroutine will ajusted as well.
   */
  void dispatch(Coroutine* next);

  /**
   * \brief Tell the coroutine currently executed.
   * \return A pointer to the coroutine that is currently executed.
   */
  Coroutine* active() { return life; }
};

#endif /* __dispatch_h__ */
