/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                            C o n s o l e                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Printing text on the NDS screen                                           */
/*---------------------------------------------------------------------------*/

#include "devices/console.h"
//#define GBA_BASE_PAL_RAM	(unsigned short *)0x5000000
//#define GBA_BASE_VRAM		(unsigned short *)0x6000000

#define VRAM_ENABLE		(1<<7)
#define VRAM_A_MAIN_BG  (1<<0)
// macro creates a 15 bit color from 3x5 bit components
 /** \brief  Macro to convert 5 bit r g b components into a single 15 bit RGB triplet */
#define RGB15(r,g,b)  ((r)|((g)<<5)|((b)<<10))

 /*! \brief The shift to apply to map base when storing it in a background control register */
 #define MAP_BASE_SHIFT 8

 /*! \brief The shift to apply to tile base when storing it in a background control register */
 #define TILE_BASE_SHIFT 2

 /*! \brief Macro to set the tile base in background control */
 #define BG_TILE_BASE(base) ((base) << TILE_BASE_SHIFT)

 /*! \brief Macro to set the map base in background control */
 #define BG_MAP_BASE(base)  ((base) << MAP_BASE_SHIFT)

#define BG_PALETTE_SUB             ((volatile unsigned short*)0x05000400)
#define BG_PALETTE                 ((volatile unsigned short*)0x05000000)
/*! \brief A macro which returns a u16* pointer to background Map ram (Sub Engine) */
#define SCREEN_BASE_BLOCK_SUB(n)	(((n)*0x800) + 0x06200000)

/*! \brief A macro which returns a u16* pointer to background tile ram (Sub Engine) */
#define CHAR_BASE_BLOCK_SUB(n)		(((n)*0x4000)+ 0x06200000)

//#define SCREEN_BASE_BLOCK(n)	(((n)*0x800) + 0x06000000)

/*! \brief A macro which returns a u16* pointer to background tile ram (Sub Engine) */
#define CHAR_BASE_BLOCK(n)		(((n)*0x4000)+ 0x06000000)
#define BG_256_COLOR   (1<<7)

#define DISPLAY_BG0_ACTIVE    (1 << 8)
#define MODE_0_2D  0x10000
#define VRAM_C_SUB_BG	 4



extern const ezstubs_uint16 fontData[3040];
extern const ezstubs_uint16 alpha8Palette[2] ;
/*---------------------------------------------------------------------------------
	consoleInit
	param:
*/

void Console::init() {
	POWERCNT = (1<<0)+(1<<1)+(1<<9)+(1<<15);//Sub Display on bottom
    DISPCNT_SUB = (DISPLAY_BG0_ACTIVE | MODE_0_2D); //Turn on Display
    VRAM_C_CR = VRAM_ENABLE | VRAM_C_SUB_BG;
    SUB_BG0_CR = BG_256_COLOR | BG_TILE_BASE(0) |  BG_MAP_BASE(20);
    volatile ezstubs_uint16* charBase = (volatile ezstubs_uint16*)CHAR_BASE_BLOCK_SUB(0);//---tiles   
    textMap  = (volatile  ezstubs_uint16 *)SCREEN_BASE_BLOCK_SUB(20);
       
    fontStart = ' ' ; 
    
    BG_PALETTE_SUB[0] = RGB15(0,0,0);
    BG_PALETTE_SUB[1] = RGB15(31,31,31);
    BG_PALETTE_SUB[255] = RGB15(31,31,31);
    for(int i = 0; i < 3040; ++i) {
      charBase[i] = fontData[i];
    }
    clear();
	consoleInitialised = 1;
}
/*
void Console::crlf() {
  unsigned char x;
  unsigned short temp16;

  xPos = 0;
  yPos++;

  if ((yPos-scrollPos)==HEIGHT) {
    scroll(1);

    if (scrollPos>=VHEIGHT && yPos>=VHEIGHT) {
     // scrollPos -= VHEIGHT;
     // yPos -= VHEIGHT;
     
    }
  }

  // clear line
  temp16 = (yPos&(VHEIGHT-1))*VWIDTH; 
  for(x=0; x<WIDTH; x++) {
    textMap[temp16 + x] = ' ' - fontStart;
  }
}
*/
void Console::crlf(){
  xPos = 0;
  	
  if(yPos == HEIGHT-1){	
  	clear();
  	yPos = 0;
  }else{
  	yPos++;
  }
}

void Console::print(char c){
	if(xPos == WIDTH){
		crlf();
	}
	if(c == 10){
		crlf();
	}else{
		textMap[yPos*WIDTH + xPos] = 	(ezstubs_uint16)(c + fontOffset - fontStart);
		xPos++;
	}
	
}

/*
void Console::print(char c) {
  ezstubs_uint16 temp16;
  temp16 = (yPos&(VHEIGHT-1))*VWIDTH;

  if (xPos==WIDTH) {
    crlf();
    temp16 = (yPos&(VHEIGHT-1))*VWIDTH;
  }

  if (c==10) {
    crlf();
    temp16 = (yPos&(VHEIGHT-1))*VWIDTH;
  }
  else {
    textMap[temp16 + xPos] =  ( (ezstubs_uint16)(c + fontOffset - fontStart)  );
    xPos++;
  }
}
*/
void Console::scroll(short val) {
 // scrollPos += val;
  //BG0VOFS = (scrollPos&(VHEIGHT-1))*8;
 // BG0VOFS = val*8;
}

void Console::clear() {
  unsigned char x, y;

  xPos = 0;
  yPos = 0;
  orMask = 0;
  scrollPos = 0;
  //scroll(0);

  for(y=0; y<HEIGHT; y++) {
    for(x=0; x<WIDTH; x++) {
      textMap[y*VWIDTH + x] = ' ' - fontStart;
    }
  }
}

void Console::setProperty(DispProp property, short val) {
  switch (property) {
  case DP_REVERSE:
    if (val)
      orMask |= 0x0080;
    else
      orMask &= ~0x0080;
    break;
    //...
  }
}


void Console::setPosition(unsigned char x, unsigned char y) {
  xPos = x;
  yPos = y + scrollPos;
}

void Console::getPosition(unsigned char *x, unsigned char *y) {
  if (x) {
    *x = (unsigned char)xPos;
  }
  if (y) {
    *y = (unsigned char)((yPos - scrollPos)&(VHEIGHT-1));
  }
}
const ezstubs_uint16 fontData[3040]={
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0101,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0001,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0101,0x0001,
    0x0100,0x0001,0x0000,0x0000,0x0000,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0101,0x0100,0x0001,
    0x0101,0x0100,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0101,0x0101,0x0000,0x0101,0x0101,0x0101,0x0101,
    0x0000,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0100,0x0101,0x0101,0x0001,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0100,0x0101,0x0101,0x0001,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,
    0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0100,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0100,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0100,0x0101,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0101,0x0000,0x0000,0x0101,0x0101,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0100,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0101,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0000,0x0000,0x0101,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0101,0x0000,0x0000,0x0000,0x0101,0x0101,0x0101,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0101,0x0101,0x0001,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0100,0x0101,0x0101,0x0001,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0100,0x0101,0x0001,0x0101,0x0100,0x0101,0x0001,
    0x0101,0x0100,0x0101,0x0001,0x0101,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0101,0x0101,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0100,0x0001,0x0000,0x0001,
    0x0100,0x0001,0x0001,0x0000,0x0100,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0001,0x0000,0x0100,0x0001,0x0000,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0100,0x0001,0x0000,0x0001,
    0x0100,0x0001,0x0001,0x0000,0x0100,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0001,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0101,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0101,0x0001,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0101,0x0101,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0101,0x0001,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0101,0x0000,0x0100,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0001,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0100,0x0001,0x0000,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0001,0x0101,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0101,0x0101,0x0101,0x0001,
    0x0101,0x0100,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0001,0x0100,0x0001,
    0x0101,0x0101,0x0100,0x0001,0x0101,0x0100,0x0101,0x0001,
    0x0101,0x0000,0x0101,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0101,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0101,0x0001,
    0x0101,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0001,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0001,0x0100,0x0101,0x0101,0x0001,
    0x0100,0x0100,0x0001,0x0001,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0100,0x0100,0x0001,
    0x0101,0x0100,0x0100,0x0001,0x0101,0x0101,0x0101,0x0001,
    0x0100,0x0001,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0001,0x0101,0x0000,0x0000,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0000,0x0101,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0001,0x0000,0x0101,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0000,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0000,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0000,0x0000,0x0000,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0101,0x0101,0x0101,0x0101,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0001,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0100,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0001,0x0101,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0000,0x0000,0x0101,0x0101,0x0001,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0101,0x0000,0x0101,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0100,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0101,0x0101,0x0001,0x0000,
    0x0101,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0100,0x0001,0x0101,0x0000,0x0100,0x0101,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0101,0x0001,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,
    0x0000,0x0000,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0000,0x0101,0x0101,0x0000,
    0x0101,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0100,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0001,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0001,0x0101,0x0000,0x0101,0x0101,0x0101,0x0001,
    0x0101,0x0100,0x0100,0x0001,0x0101,0x0100,0x0100,0x0001,
    0x0101,0x0100,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0100,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0100,0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,
    0x0100,0x0001,0x0100,0x0001,0x0100,0x0101,0x0101,0x0000,
    0x0100,0x0001,0x0000,0x0000,0x0101,0x0101,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0101,0x0000,0x0101,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0100,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0101,0x0000,0x0000,0x0100,0x0101,0x0001,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0100,0x0101,0x0000,0x0100,0x0101,0x0100,0x0001,
    0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,0x0000,
    0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0001,0x0101,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,
    0x0101,0x0101,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0101,0x0101,0x0101,0x0000,0x0000,0x0101,0x0000,0x0000,
    0x0000,0x0101,0x0000,0x0000,0x0000,0x0101,0x0100,0x0001,
    0x0000,0x0100,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,0x0101,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0100,0x0100,0x0001,
    0x0101,0x0100,0x0100,0x0001,0x0101,0x0101,0x0101,0x0001,
    0x0100,0x0001,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0001,0x0101,0x0000,
    0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0101,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0101,0x0000,0x0100,0x0001,0x0101,0x0000,0x0100,0x0001,
    0x0101,0x0000,0x0100,0x0001,0x0100,0x0101,0x0101,0x0001,
    0x0000,0x0000,0x0100,0x0001,0x0101,0x0101,0x0101,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0101,0x0001,0x0100,0x0000,0x0101,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0101,0x0000,0x0001,
    0x0100,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0101,0x0001,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0100,0x0101,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0000,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0000,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0000,0x0101,0x0001,
    0x0000,0x0100,0x0001,0x0000,0x0000,0x0100,0x0001,0x0000,
    0x0100,0x0101,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0100,0x0101,0x0100,0x0001,0x0101,0x0100,0x0101,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    
    };



Console console;
