/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               D E R I V A T E                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Oft wird derselbe Prozessorkern, der durch die Klasse CPU repräsentiert   */
/* wird in vielen verschiedenen Mikrocontrollern, sog. Derivaten verwendet.  */
/* Die Klasse Derivate stellt nun eine Abstraktion für eben diese Derivate   */
/* dar.                                                                      */
/*****************************************************************************/

#ifndef __derivate_h__
#define __derivate_h__

#include "devices/derivate_implementation.h"
#include "infra/types.h"
#include "infra/memory_mapped.h"

/**
 * \class Derivate
 * \brief Abstraction of a cpu architecture.
 *
 * A concrete CPU-Architecture often is used for quite many different dies,
 * so called derivates. These derivates have in common the architecture but 
 * differ in many other things, these differences are mirrored by the 
 * different derivate implementation.
 */
class Derivate : public Derivate_Implementation {
};

extern Derivate cpu;

#endif /* __derivate_h__ */
