#ifndef __types_h__
#define __types_h__

/**
 * \file types.h
 * \brief Definitions of datatypes that should be used for the user interface
 **/

#include "infra/archtypes.h"

/**
 * \brief nano seconds
 **/
typedef ezstubs_uint32     ns_type;

/**
 * \brief micro seconds
 **/
typedef ezstubs_uint32     us_type;

/**
 * \brief milli seconds
 **/
typedef ezstubs_uint32     ms_type;

/**
 * \brief timer ticks
 **/
typedef ezstubs_uint16     tick_type;

/**
 * \brief counter ticks
 **/
typedef ezstubs_uint64     counter_tick_type;

/**
 * \brief thread priorities
 **/
typedef ezstubs_uint8      prio_type;

#endif /* __types_h__ */
