/* -*- c++ -*- ***************************************************************/
/* Echtzeitsysteme                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                                 U T I L S                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Just a bunch of defines that are helpful here and there.                  */
/*---------------------------------------------------------------------------*/

#ifndef __utils_h__
#define __utils_h__

#include "infra/types.h"

#define LOOP_BUSY(x) for(volatile ezstubs_uint16 counter = x;counter > 0;counter--);

#define MAX(a,b) a > b ? a : b
#define MIN(a,b) a > b ? b : a

template < typename T > T gcd(T a,T b) {
  T temp = MAX(a,b);
  a = MIN(a,b);

  if(a == 0) {
    return b;
  }

  do {
    b = temp % a;
    temp = a;
    a = b;
  } while(b != 0);

  return temp;
}

#endif /* __utils_h__ */
