#ifndef __shutdown_h__
#define __shutdown_h__

/**
 * \brief Stop the OS
 *
 * This function should never be called within normal operation. As the 
 * function main() or Scheduler::start() shall never return. But if these
 * functions nevertheless return, the function stop() will be called after
 * global destructors are executed. The stop()-function can run in an 
 * endless loop or jump to the reset-vector, for example.
 */
void stop(void);

/**
 * \brief Invoke destructors for global objects.
 */
void invoke_destructors(void);

#endif /* __shutdown_h__ */
