
# TOC_SWITCH : Prozessumschaltung. Der aktuelle Registersatz wird     
#              gesichert und der Registersatz des neuen "thread of control"
#              wird in den Prozessor eingelesen.  
#
# C Prototyp: void toc_switch (void** sp_now,  
#                              void*  sp_then)
# r0 : sp_now
# r1 : sp_then
#
# register we have to seve
# r4 - r12, r13 (stack pointer), r14 (link register)
#
#
# our pcb has the following layout
#
# ----------------
# |     cpsr     |
# ----------------
# |   r14 (lr)   |
# ----------------
# |      r4      |
# ----------------
# |      r5      |
# ----------------
# |      r6      |
# ----------------
# |      r7      |
# ----------------
# |      r8      |
# ----------------
# |      r9      |
# ----------------
# |      r10     |
# ----------------
# |      r11     |
# ----------------
# |      r12     |
# ---------------- <- r13 (sp)
#

	.global		_switch_context
	.global		switch_context
	.global		_load_context
	.global		load_context
	.section	.text

switch_context:
_switch_context:

	# store cpsr and link register

	mrs	r2,cpsr
	stmfd	sp!,{r2}
	stmfd	sp!,{lr}
	
	# push non-volatile general purpose registers
	# these are r4 - r12
	
	stmfd	sp!,{r4-r12}
	
	# save current SP to sp_now

	str	sp,[r0]
	mov	r0,r1

load_context:
_load_context:
	
	# restore sp
	
	mov	sp,r0

	# restore non-volatile registers again

	ldmfd	sp!,{r4-r12}

	# restore cpsr and link register 

	ldmfd	sp!,{lr}
	ldmfd	sp!,{r2}
	msr	CPSR_cxsf,r2
		
	# return
	
	mov	pc,lr

